/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.projectView;

import com.intellij.ide.projectView.ProjectViewNestingRulesProvider;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JSNestingRulesProvider
implements ProjectViewNestingRulesProvider {
    private static final Map<String, List<String>> TS_NESTING = Map.of(".ts", List.of(".js", ".mjs", ".cjs"), ".mts", List.of(".js", ".mjs"), ".cts", List.of(".js", ".cjs"), ".tsx", List.of(".js", ".jsx"));

    public void addFileNestingRules(@NotNull ProjectViewNestingRulesProvider.Consumer consumer) {
        if (consumer == null) {
            JSNestingRulesProvider.$$$reportNull$$$0(0);
        }
        consumer.addNestingRule(".js", ".min.js");
        consumer.addNestingRule(".js", ".min.js.map");
        consumer.addNestingRule(".js", ".map");
        consumer.addNestingRule(".js", ".js.map");
        consumer.addNestingRule(".js", "-compiled.js");
        consumer.addNestingRule(".js", "-compiled.js.map");
        consumer.addNestingRule(".cjs", ".cjs.map");
        consumer.addNestingRule(".mjs", ".mjs.map");
        consumer.addNestingRule(".jsx", ".js");
        consumer.addNestingRule(".jsx", ".js.map");
        consumer.addNestingRule(".es6", ".js");
        consumer.addNestingRule(".es6", ".js.map");
        JSNestingRulesProvider.addTypeScriptNestingRules(consumer);
    }

    private static void addTypeScriptNestingRules(@NotNull ProjectViewNestingRulesProvider.Consumer consumer) {
        if (consumer == null) {
            JSNestingRulesProvider.$$$reportNull$$$0(1);
        }
        for (String tsExt : TypeScriptUtil.TYPESCRIPT_EXTENSIONS_WITHOUT_DECLARATIONS) {
            for (String jsExt : TS_NESTING.get(tsExt)) {
                consumer.addNestingRule(tsExt, jsExt);
                consumer.addNestingRule(tsExt, jsExt + ".map");
            }
            String declarationExt = (String)TypeScriptUtil.TS_SOURCE_TO_DECLARATION_EXTENSION.get(tsExt);
            if (declarationExt == null) continue;
            consumer.addNestingRule(tsExt, declarationExt);
            consumer.addNestingRule(tsExt, declarationExt + ".map");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "consumer";
        objectArray2[1] = "com/intellij/lang/javascript/projectView/JSNestingRulesProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addFileNestingRules";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addTypeScriptNestingRules";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

