/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSAwaitCompletionProvider;
import com.intellij.lang.javascript.completion.JSReferenceCompletionProvider;
import com.intellij.lang.javascript.evaluation.JSCodeBasedTypeFactory;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSElvisType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class JSOptChainCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context2, @NotNull CompletionResultSet result2) {
        if (parameters2 == null) {
            JSOptChainCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            JSOptChainCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            JSOptChainCompletionProvider.$$$reportNull$$$0(2);
        }
        if (!JSApplicationSettings.getInstance().isOptChainCompletion()) {
            return;
        }
        PsiElement parent = parameters2.getPosition().getParent();
        assert (parent instanceof JSReferenceExpression);
        if (JSReferenceCompletionProvider.skipReferenceCompletionByContext(parameters2.getPosition())) {
            return;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)parent);
        if (holder == null || !holder.isTypeScript && !holder.isECMA6) {
            return;
        }
        JSReferenceExpression referenceExpression = (JSReferenceExpression)parent;
        if (referenceExpression.getReferenceKind() != JSReferenceExpression.Kind.PropertyAccess) {
            return;
        }
        JSAwaitCompletionProvider.handleCompletionWithExtraItemToApply(parameters2, result2, referenceExpression, (Consumer<? super PsiElement>)((Consumer)e -> {
            JSReferenceExpression expression = (JSReferenceExpression)ObjectUtils.tryCast((Object)e.getParent(), JSReferenceExpression.class);
            if (expression != null) {
                ASTNode dotToken = expression.getNode().findChildByType(JSTokenTypes.DOT);
                assert (dotToken != null);
                dotToken.getPsi().replace(JSChangeUtil.createTokenElement((PsiElement)expression, (IElementType)JSTokenTypes.ELVIS, (CharSequence)"?."));
            } else {
                PsiElement leaf = PsiTreeUtil.prevLeaf((PsiElement)e);
                if (leaf instanceof PsiErrorElement) {
                    leaf = PsiTreeUtil.prevLeaf((PsiElement)leaf);
                }
                assert (PsiUtilCore.getElementType((PsiElement)leaf) == JSTokenTypes.DOT);
                leaf.replace(JSChangeUtil.createTokenElement((PsiElement)leaf.getParent(), (IElementType)JSTokenTypes.ELVIS, (CharSequence)"?."));
            }
        }), "?", (Condition<? super JSType>)((Condition)JSOptChainCompletionProvider::hasNullOrUndefinedComponents), qualifier -> {
            JSType qualifierCodeBasedType = JSCodeBasedTypeFactory.getCodeBasedType((JSExpression)qualifier, (boolean)true, (boolean)false);
            if (qualifierCodeBasedType == null) {
                return null;
            }
            return JSElvisType.applyNonFinalElvisContext((JSType)qualifierCodeBasedType, (boolean)false);
        }, false, null);
    }

    private static boolean hasNullOrUndefinedComponents(JSType t) {
        JSType type2 = JSCompositeTypeFactory.optimizeTypeIfComposite((JSType)t);
        return type2 instanceof JSUnionType && ((JSUnionType)type2).getTypes().stream().anyMatch(tt -> tt instanceof JSNullType || tt instanceof JSUndefinedType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/completion/JSOptChainCompletionProvider";
        objectArray[2] = "addCompletions";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

