/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.yarn.pnp.model;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.Deque;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0010\u001a\u00020\u0003J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0002J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/javascript/nodejs/library/yarn/pnp/model/YarnPnpDependencyTreeTargetPathConverter;", "", "json", "", "targetRun", "Lcom/intellij/javascript/nodejs/execution/NodeTargetRun;", "<init>", "(Ljava/lang/String;Lcom/intellij/javascript/nodejs/execution/NodeTargetRun;)V", "reader", "Lcom/google/gson/stream/JsonReader;", "stringWriter", "Ljava/io/StringWriter;", "writer", "Lcom/google/gson/stream/JsonWriter;", "currentPath", "Ljava/util/Deque;", "getJsonWithLocalPaths", "process", "", "pathComponent", "convert", "value", "convertTargetPathToLocal", "targetPath", "intellij.javascript.backend"})
@SourceDebugExtension(value={"SMAP\nYarnPnpDependencyTreeTargetPathConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YarnPnpDependencyTreeTargetPathConverter.kt\ncom/intellij/javascript/nodejs/library/yarn/pnp/model/YarnPnpDependencyTreeTargetPathConverter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,96:1\n13#2:97\n*S KotlinDebug\n*F\n+ 1 YarnPnpDependencyTreeTargetPathConverter.kt\ncom/intellij/javascript/nodejs/library/yarn/pnp/model/YarnPnpDependencyTreeTargetPathConverter\n*L\n92#1:97\n*E\n"})
public final class YarnPnpDependencyTreeTargetPathConverter {
    @NotNull
    private final NodeTargetRun targetRun;
    @NotNull
    private final JsonReader reader;
    @NotNull
    private final StringWriter stringWriter;
    @NotNull
    private final JsonWriter writer;
    @NotNull
    private final Deque<String> currentPath;

    public YarnPnpDependencyTreeTargetPathConverter(@NotNull String json, @NotNull NodeTargetRun targetRun) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)targetRun, (String)"targetRun");
        this.targetRun = targetRun;
        this.reader = new JsonReader((Reader)new StringReader(json));
        this.stringWriter = new StringWriter(json.length());
        this.writer = new JsonWriter((Writer)this.stringWriter);
        this.currentPath = new ArrayDeque();
    }

    @NotNull
    public final String getJsonWithLocalPaths() throws IOException {
        this.process("");
        String string = this.stringWriter.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void process(String pathComponent) throws IOException {
        this.currentPath.addLast(pathComponent);
        JsonToken jsonToken = this.reader.peek();
        switch (jsonToken == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jsonToken.ordinal()]) {
            case 1: {
                this.reader.beginObject();
                this.writer.beginObject();
                while (this.reader.hasNext()) {
                    String propName = this.reader.nextName();
                    this.writer.name(propName);
                    Intrinsics.checkNotNull((Object)propName);
                    this.process(propName);
                }
                this.writer.endObject();
                this.reader.endObject();
                Unit unit = Unit.INSTANCE;
                break;
            }
            case 2: {
                this.reader.beginArray();
                this.writer.beginArray();
                while (this.reader.hasNext()) {
                    this.process("[");
                }
                this.writer.endArray();
                this.reader.endArray();
                Unit unit = Unit.INSTANCE;
                break;
            }
            case 3: {
                this.reader.nextNull();
                Unit unit = this.writer.nullValue();
                break;
            }
            case 4: {
                String string = this.reader.nextString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nextString(...)");
                Unit unit = this.writer.value(this.convert(string));
                break;
            }
            case 5: {
                Unit unit = this.writer.value(this.reader.nextLong());
                break;
            }
            case 6: {
                Unit unit = this.writer.value(this.reader.nextBoolean());
                break;
            }
            default: {
                this.reader.skipValue();
                Unit unit = Unit.INSTANCE;
            }
        }
        this.currentPath.pollLast();
    }

    private final String convert(String value) {
        String lastPathComponent = this.currentPath.getLast();
        if (Intrinsics.areEqual((Object)"requireableLocation", (Object)lastPathComponent) || Intrinsics.areEqual((Object)"resolvedVirtualRequireableLocation", (Object)lastPathComponent) || Intrinsics.areEqual((Object)"location", (Object)lastPathComponent)) {
            return this.convertTargetPathToLocal(value);
        }
        return value;
    }

    private final String convertTargetPathToLocal(String targetPath) {
        String string;
        Promise<String> promise = this.targetRun.convertTargetPathToLocal(targetPath);
        if (promise.getState() == Promise.State.PENDING) {
            throw new RuntimeException("Still pending for " + targetPath);
        }
        try {
            Object object = promise.blockingGet(0);
            Intrinsics.checkNotNull((Object)object);
            string = (String)object;
        }
        catch (Exception e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(YarnPnpDependencyTreeTargetPathConverter.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("Cannot convert target path " + targetPath + " to local", (Throwable)e);
            string = targetPath;
        }
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JsonToken.values().length];
            try {
                nArray[JsonToken.BEGIN_OBJECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonToken.BEGIN_ARRAY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonToken.NULL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonToken.STRING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonToken.NUMBER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonToken.BOOLEAN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

