/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.jam.utils;

import com.intellij.aop.AopAdvice;
import com.intellij.aop.AopAdvisedElementsSearcher;
import com.intellij.aop.AopAspect;
import com.intellij.aop.AopIntroduction;
import com.intellij.aop.AopProvider;
import com.intellij.aop.jam.JamAopModel;
import com.intellij.aop.jam.utils.AopModelSearchers;
import com.intellij.aop.psi.AopPointcutUtil;
import com.intellij.aop.psi.AopReferenceHolder;
import com.intellij.aop.psi.PointcutMatchDegree;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class AopModelUtils {
    public static List<AopIntroduction> getBoundIntroductions(PsiClass psiClass) {
        Project project = psiClass.getProject();
        return DumbService.isDumb((Project)project) ? Collections.emptyList() : (List)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> CachedValueProvider.Result.create(AopModelUtils.calcBoundIntroductions(psiClass, true), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    public static List<AopIntroduction> calcBoundIntroductions(PsiClass psiClass, boolean checkAdvisable) {
        if (psiClass.hasModifierProperty("abstract")) {
            return Collections.emptyList();
        }
        List<AopProvider> providers = AopModelSearchers.getAopProviders(psiClass);
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (module == null || providers.isEmpty()) {
            return Collections.emptyList();
        }
        SmartList boundIntros = new SmartList();
        PsiClassType type = AopModelUtils.createPsiType(psiClass);
        for (AopAspect aspect : AopModelUtils.getAspects(psiClass)) {
            for (AopIntroduction aopIntroduction : aspect.getIntroductions()) {
                AopAdvisedElementsSearcher searcher;
                AopReferenceHolder holder = (AopReferenceHolder)aopIntroduction.getTypesMatching().getValue();
                if (holder == null || holder.accepts((PsiType)type) != PointcutMatchDegree.TRUE || !(searcher = AopPointcutUtil.getHolder((PsiElement)holder).getAopModel().getAdvisedElementsSearcher()).isInherentlyAdvisable(psiClass) || checkAdvisable && !searcher.isAdvisableInModel(psiClass)) continue;
                boundIntros.add(aopIntroduction);
            }
        }
        return boundIntros;
    }

    public static Set<AopAspect> getAspects(PsiClass psiClass) {
        return (Set)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
            Set<Object> set = new HashSet();
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
            List<AopProvider> providers = AopModelSearchers.getAopProviders(psiClass);
            if (module != null && !providers.isEmpty()) {
                List modules = ModuleUtilCore.getAllDependentModules((Module)module);
                modules.add(module);
                AopModelUtils.collectAspects(providers, modules, set);
            }
            if (set.isEmpty()) {
                set = Collections.emptySet();
            }
            return CachedValueProvider.Result.create(set, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    private static void collectAspects(List<? extends AopProvider> providers, List<Module> modules, Set<? super AopAspect> aspects) {
        aspects.addAll(new JamAopModel(modules).getAspects());
        for (AopProvider aopProvider : providers) {
            for (Module module : modules) {
                aspects.addAll(aopProvider.getAdditionalAspects(module));
            }
        }
    }

    public static PsiClassType createPsiType(PsiClass psiClass) {
        return JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory().createType(psiClass);
    }

    public static boolean isAdviceAcceptingMethod(AopAdvice advice, PsiMethod method, AopAdvisedElementsSearcher searcher, boolean checkClass) {
        if (!searcher.canBeAdvised(method)) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (!(!checkClass || containingClass != null && containingClass.getQualifiedName() != null && searcher.isInherentlyAdvisable(containingClass) && AopAdvisedElementsSearcher.isAspectjAdvisable(containingClass))) {
            return false;
        }
        return advice.accepts(method) == PointcutMatchDegree.TRUE && searcher.acceptsBoundMethodHeavy(method) && containingClass != null && (!checkClass || searcher.isAdvisableInModel(containingClass));
    }

    private static int getAdviceOrder(AopAdvice advice, List<? extends AopProvider> providers) {
        for (AopProvider aopProvider : providers) {
            Integer order = aopProvider.getAdviceOrder(advice);
            if (order == null) continue;
            return order;
        }
        return Integer.MAX_VALUE;
    }

    public static Map<AopAdvice, Integer> addBoundAdvices(PsiMethod method, Collection<? extends AopAspect> aspects, List<? extends AopProvider> providers) {
        LinkedHashMap<AopAdvice, Integer> boundAdvices = new LinkedHashMap<AopAdvice, Integer>();
        for (AopAspect aopAspect : aspects) {
            for (AopAdvice aopAdvice : aopAspect.getAdvices()) {
                ProgressManager.checkCanceled();
                AopAdvisedElementsSearcher searcher = aopAdvice.getSearcher();
                if (searcher == null || !AopModelUtils.isAdviceAcceptingMethod(aopAdvice, method, searcher, true)) continue;
                boundAdvices.put(aopAdvice, AopModelUtils.getAdviceOrder(aopAdvice, providers));
            }
        }
        return boundAdvices;
    }

    public static Map<AopAdvice, Integer> getBoundAdvices(PsiClass psiClass) {
        return (Map)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
            HashMap<AopAdvice, Integer> result = new HashMap<AopAdvice, Integer>();
            List<AopProvider> providers = AopModelSearchers.getAopProviders(psiClass);
            Set<AopAspect> aspects = AopModelUtils.getAspects(psiClass);
            for (PsiMethod method : psiClass.getMethods()) {
                result.putAll(AopModelUtils.addBoundAdvices(method, aspects, providers));
            }
            return CachedValueProvider.Result.create(result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }
}

