/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.VariableViewKt;
import org.jetbrains.wip.protocol.runtime.EntryPreviewValue;
import org.jetbrains.wip.protocol.runtime.ObjectPreviewValue;
import org.jetbrains.wip.protocol.runtime.PropertyPreviewValue;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u001c\u0010\u0006\u001a\u00020\u0007*\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u001e\u0010\f\u001a\u00020\u00012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a8\u0006\u0014"}, d2={"renderProperty", "", "property", "Lorg/jetbrains/wip/protocol/runtime/PropertyPreviewValue;", "renderer", "Lcom/intellij/xdebugger/frame/presentation/XValuePresentation$XValueTextRenderer;", "renderPrimitive", "", "type", "Lorg/jetbrains/wip/protocol/runtime/PropertyPreviewValue$Type;", "value", "", "renderMap", "entries", "", "Lorg/jetbrains/wip/protocol/runtime/EntryPreviewValue;", "renderValue", "preview", "Lorg/jetbrains/wip/protocol/runtime/ObjectPreviewValue;", "object2PropertyPVType", "intellij.javascript.wip.backend"})
@SourceDebugExtension(value={"SMAP\nWipObject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WipObject.kt\norg/jetbrains/wip/WipObjectKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,192:1\n1#2:193\n*E\n"})
public final class WipObjectKt {
    public static final void renderProperty(@NotNull PropertyPreviewValue property, @NotNull XValuePresentation.XValueTextRenderer renderer) {
        String string;
        ObjectPreviewValue objectPreviewValue;
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        if (property.getValue() != null) {
            String string2 = property.getValue();
            Intrinsics.checkNotNull((Object)string2);
            if (((CharSequence)string2).length() > 0 || property.type() == PropertyPreviewValue.Type.STRING) {
                PropertyPreviewValue.Type type = property.type();
                String string3 = property.getValue();
                Intrinsics.checkNotNull((Object)string3);
                if (!WipObjectKt.renderPrimitive(renderer, type, string3)) {
                    if (property.getSubtype() == null && Intrinsics.areEqual((Object)property.getValue(), (Object)"Object")) {
                        renderer.renderValue("{\u2026}");
                    } else if (property.getSubtype() == PropertyPreviewValue.Subtype.REGEXP) {
                        String string4 = property.getValue();
                        Intrinsics.checkNotNull((Object)string4);
                        renderer.renderValue(string4, JSHighlighter.JS_REGEXP);
                    } else {
                        String string5 = property.getValue();
                        Intrinsics.checkNotNull((Object)string5);
                        renderer.renderValue(string5);
                    }
                }
                return;
            }
        }
        if ((objectPreviewValue = property.getValuePreview()) != null) {
            ObjectPreviewValue it = objectPreviewValue;
            boolean bl = false;
            WipObjectKt.renderValue(it, renderer);
            return;
        }
        if (property.type() == PropertyPreviewValue.Type.FUNCTION) {
            renderer.renderValue("\u0192");
            return;
        }
        Object object = property.getSubtype();
        if (object == null || (object = object.name()) == null) {
            object = property.type().name();
        }
        PropertyPreviewValue.Subtype type = object;
        XValuePresentation.XValueTextRenderer xValueTextRenderer = renderer;
        String string6 = type.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toLowerCase(...)");
        String string7 = string6;
        if (((CharSequence)string7).length() > 0) {
            char it = string7.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            XValuePresentation.XValueTextRenderer xValueTextRenderer2 = xValueTextRenderer;
            boolean bl = false;
            String string8 = String.valueOf(it);
            Intrinsics.checkNotNull((Object)string8, (String)"null cannot be cast to non-null type java.lang.String");
            String string9 = string8.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"toUpperCase(...)");
            CharSequence charSequence = string9;
            xValueTextRenderer = xValueTextRenderer2;
            StringBuilder stringBuilder2 = stringBuilder.append((Object)charSequence);
            String string10 = string7;
            int n = 1;
            String string11 = string10.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"substring(...)");
            string = stringBuilder2.append(string11).toString();
        } else {
            string = string7;
        }
        xValueTextRenderer.renderValue(string);
    }

    public static final boolean renderPrimitive(@NotNull XValuePresentation.XValueTextRenderer $this$renderPrimitive, @NotNull PropertyPreviewValue.Type type, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$renderPrimitive, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                $this$renderPrimitive.renderKeywordValue(value);
                break;
            }
            case 4: 
            case 5: {
                $this$renderPrimitive.renderNumericValue(value);
                break;
            }
            case 6: {
                $this$renderPrimitive.renderStringValue(value, "\"\\", 1000);
                int actualStringLength = value.length();
                if (actualStringLength <= 1000) break;
                Object[] objectArray = new Object[]{actualStringLength};
                $this$renderPrimitive.renderComment(XDebuggerBundle.message((String)"node.text.ellipsis.truncated", (Object[])objectArray));
                break;
            }
            case 7: {
                $this$renderPrimitive.renderComment(VariableViewKt.trimFunctionDescription((String)value));
                break;
            }
            case 8: {
                return false;
            }
            default: {
                $this$renderPrimitive.renderValue(value);
            }
        }
        return true;
    }

    private static final void renderMap(List<? extends EntryPreviewValue> entries, XValuePresentation.XValueTextRenderer renderer) {
        boolean isFirst = true;
        for (EntryPreviewValue entryPreviewValue : entries) {
            if (isFirst) {
                isFirst = false;
            } else {
                renderer.renderSpecialSymbol(",\n");
            }
            if (entryPreviewValue.getKey() != null) {
                ObjectPreviewValue it;
                boolean bl = false;
                WipObjectKt.renderValue(it, renderer);
                renderer.renderSpecialSymbol(" => ");
            }
            WipObjectKt.renderValue(entryPreviewValue.value(), renderer);
        }
    }

    private static final void renderValue(ObjectPreviewValue preview, XValuePresentation.XValueTextRenderer renderer) {
        Object it;
        String string = preview.getDescription();
        if (string != null) {
            it = string;
            boolean bl = false;
            if (WipObjectKt.renderPrimitive(renderer, WipObjectKt.object2PropertyPVType(preview), (String)it)) {
                return;
            }
            renderer.renderComment((String)it);
        }
        renderer.renderSpecialSymbol(" {");
        List list = preview.getEntries();
        if (list != null) {
            it = list;
            boolean bl = false;
            WipObjectKt.renderMap((List<? extends EntryPreviewValue>)it, renderer);
        }
        boolean isFirst = true;
        for (PropertyPreviewValue property : preview.properties()) {
            if (isFirst) {
                isFirst = false;
            } else {
                renderer.renderSpecialSymbol(",\n");
            }
            renderer.renderValue(property.name(), JSHighlighter.JS_INSTANCE_MEMBER_VARIABLE);
            renderer.renderSpecialSymbol(": ");
            WipObjectKt.renderProperty(property, renderer);
        }
        if (preview.getOverflow()) {
            renderer.renderComment(",\n...");
        }
        renderer.renderSpecialSymbol("}");
    }

    @NotNull
    public static final PropertyPreviewValue.Type object2PropertyPVType(@NotNull ObjectPreviewValue preview) {
        Intrinsics.checkNotNullParameter((Object)preview, (String)"preview");
        return switch (WhenMappings.$EnumSwitchMapping$1[preview.type().ordinal()]) {
            case 1 -> PropertyPreviewValue.Type.OBJECT;
            case 2 -> PropertyPreviewValue.Type.FUNCTION;
            case 3 -> PropertyPreviewValue.Type.UNDEFINED;
            case 4 -> PropertyPreviewValue.Type.STRING;
            case 5 -> PropertyPreviewValue.Type.NUMBER;
            case 6 -> PropertyPreviewValue.Type.BIGINT;
            case 7 -> PropertyPreviewValue.Type.BOOLEAN;
            case 8 -> PropertyPreviewValue.Type.SYMBOL;
            case 9 -> PropertyPreviewValue.Type.NO_ENUM_CONST;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static final /* synthetic */ void access$renderValue(ObjectPreviewValue preview, XValuePresentation.XValueTextRenderer renderer) {
        WipObjectKt.renderValue(preview, renderer);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[PropertyPreviewValue.Type.values().length];
            try {
                nArray[PropertyPreviewValue.Type.BOOLEAN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyPreviewValue.Type.UNDEFINED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyPreviewValue.Type.SYMBOL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyPreviewValue.Type.NUMBER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyPreviewValue.Type.BIGINT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyPreviewValue.Type.STRING.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyPreviewValue.Type.FUNCTION.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyPreviewValue.Type.OBJECT.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ObjectPreviewValue.Type.values().length];
            try {
                nArray[ObjectPreviewValue.Type.OBJECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObjectPreviewValue.Type.FUNCTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObjectPreviewValue.Type.UNDEFINED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObjectPreviewValue.Type.STRING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObjectPreviewValue.Type.NUMBER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObjectPreviewValue.Type.BIGINT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObjectPreviewValue.Type.BOOLEAN.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObjectPreviewValue.Type.SYMBOL.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObjectPreviewValue.Type.NO_ENUM_CONST.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

