/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs.factories;

import com.google.common.collect.Iterables;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlKIFKImpl;
import com.intellij.sql.psi.stubs.elementStubs.SqlTableKeyStub;
import com.intellij.sql.psi.stubs.elementTypes.SqlNamedStubElementType;
import com.intellij.sql.psi.stubs.factories.SqlDefinitionExStubElementFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.StringRef;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class SqlTableKeyStubElementFactory<T extends SqlDefinition>
extends SqlDefinitionExStubElementFactory<SqlTableKeyStub<T>, T> {
    public SqlTableKeyStubElementFactory(@NotNull SqlNamedStubElementType elementType) {
        if (elementType == null) {
            SqlTableKeyStubElementFactory.$$$reportNull$$$0(0);
        }
        super(elementType);
    }

    @Override
    @NotNull
    public SqlTableKeyStub<T> createStub(@NotNull T psi, StubElement<?> parentStub) {
        if (psi == null) {
            SqlTableKeyStubElementFactory.$$$reportNull$$$0(1);
        }
        SqlKIFKImpl impl = (SqlKIFKImpl)((Object)psi);
        String tableName = impl.getTableName();
        List columnNames = ContainerUtil.map(SqlImplUtil.getReferenceList(impl.getColumnsList()), PsiElement::getText);
        String keyText = tableName == null ? null : SqlTableKeyStubElementFactory.tableColumnList(tableName, columnNames);
        SqlNameElement nameElement = impl.getNameElement();
        return new SqlTableKeyStub(parentStub, this.elementType, SqlTableKeyStubElementFactory.asStringRef((PsiElement)nameElement), SqlTableKeyStubElementFactory.buildProperties(psi), keyText == null ? null : StringRef.fromString((String)keyText));
    }

    static String tableColumnList(String tableName, Iterable<String> columnNames) {
        if (Iterables.isEmpty(columnNames)) {
            return tableName;
        }
        return tableName + "(" + StringUtil.join(columnNames, (String)",") + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/psi/stubs/factories/SqlTableKeyStubElementFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createStub";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

