/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs.elementTypes;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ParsingDiagnostics;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtilBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlCodeBlockElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlLazyElementTypeImpl;
import com.intellij.sql.psi.impl.lexer.SqlPreprocessingLexer;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.TreeTraversal;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlFileElementType
extends IFileElementType {
    public static final Key<Language> HOST_LANGUAGE = Key.create((String)"FORCED_HOST_LANGUAGE");
    private static final Key<Boolean> PL_SUB_DIALECT = Key.create((String)"PL_SUB_DIALECT");

    public SqlFileElementType(@NonNls String debugName, Language language) {
        super(debugName, language);
    }

    protected ASTNode doParseContents(@NotNull ASTNode chameleon, @NotNull PsiElement outerPsi) {
        if (chameleon == null) {
            SqlFileElementType.$$$reportNull$$$0(0);
        }
        if (outerPsi == null) {
            SqlFileElementType.$$$reportNull$$$0(1);
        }
        PsiElement psi = chameleon.getPsi();
        Language language = this.getLanguageForParser(psi);
        SqlFileElementType.assertPlainSql(chameleon, outerPsi, language);
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        PsiElement host = SqlFileElementType.getHostElement(SqlLazyElementTypeImpl.getContextElement(psi));
        Lexer lexer = this.createLexer(parserDefinition, psi, host);
        boolean isPl = SqlFileElementType.isPlSubDialect(psi, host);
        SqlFileElementType.setPlSubDialect(psi, isPl);
        PsiBuilder builder2 = PsiBuilderFactory.getInstance().createBuilder(psi.getProject(), chameleon, lexer, language, chameleon.getChars());
        long startTime = System.nanoTime();
        PsiParser parser = this.createParser(parserDefinition, psi, host, isPl);
        ASTNode result = parser.parse((IElementType)this, builder2).getFirstChildNode();
        ParsingDiagnostics.registerParse((PsiBuilder)builder2, (Language)language, (long)(System.nanoTime() - startTime));
        return result;
    }

    private static void assertPlainSql(@NotNull ASTNode chameleon, @NotNull PsiElement outerPsi, Language language) {
        if (chameleon == null) {
            SqlFileElementType.$$$reportNull$$$0(2);
        }
        if (outerPsi == null) {
            SqlFileElementType.$$$reportNull$$$0(3);
        }
        if (!language.getID().equals("SQL")) {
            return;
        }
        Logger logger = Logger.getInstance(SqlFileElementType.class);
        StringBuilder diagnostic = new StringBuilder();
        SqlFileElementType.dumpPath("outer psi", outerPsi, diagnostic, SyntaxTraverser.psiApi(), e -> SqlFileElementType.getHostElement(SqlLazyElementTypeImpl.getContextElement(e)));
        diagnostic.append("\n\n");
        SqlFileElementType.dumpPath("chameleon", chameleon, diagnostic, SyntaxTraverser.astApi(), null);
        logger.error("Parsing of SQL without dialect should not be invoked", new Attachment[]{new Attachment("paths.txt", diagnostic.toString())});
    }

    private static <T> void dumpPath(String header, @NotNull T start, StringBuilder diagnostic, SyntaxTraverser.ApiEx<T> api, @Nullable Function<T, T> context) {
        if (start == null) {
            SqlFileElementType.$$$reportNull$$$0(4);
        }
        Function parentNContext = n -> JBIterable.of((Object[])new Object[]{api.parent(n), context == null ? null : context.fun(n)}).filterNotNull().unique();
        TreeTraversal.TracingIt it = (TreeTraversal.TracingIt)((JBTreeTraverser)JBTreeTraverser.from((Function)parentNContext).withRoot(start)).traverse().typedIterator();
        diagnostic.append(header).append(":\n");
        while (it.advance()) {
            int depth = it.backtrace().size();
            StringUtil.repeatSymbol((Appendable)diagnostic, (char)'\t', (int)depth);
            diagnostic.append(api.typeOf(it.current())).append("\n");
        }
    }

    public static void setPlSubDialect(PsiElement psi, boolean isPl) {
        PL_SUB_DIALECT.set((UserDataHolder)psi, (Object)(isPl ? Boolean.valueOf(true) : null));
    }

    public static boolean isInPl(PsiElement psi) {
        PsiElement root = PsiTreeUtil.getNonStrictParentOfType((PsiElement)psi, (Class[])new Class[]{SqlCodeBlockElement.class, SqlFile.class});
        return Boolean.TRUE.equals(PL_SUB_DIALECT.get((UserDataHolder)root));
    }

    private static boolean isPlSubDialect(PsiElement psi, PsiElement host) {
        return Boolean.TRUE.equals(PL_SUB_DIALECT.get((UserDataHolder)(psi instanceof SqlCodeBlockElement || host == null ? psi : host)));
    }

    protected PsiParser createParser(@NotNull ParserDefinition parserDefinition, @NotNull PsiElement psi, @Nullable PsiElement host, boolean isPl) {
        if (parserDefinition == null) {
            SqlFileElementType.$$$reportNull$$$0(5);
        }
        if (psi == null) {
            SqlFileElementType.$$$reportNull$$$0(6);
        }
        return parserDefinition.createParser(psi.getProject());
    }

    @NotNull
    protected Lexer createLexer(@NotNull ParserDefinition parserDefinition, @NotNull PsiElement psi, @Nullable PsiElement host) {
        if (parserDefinition == null) {
            SqlFileElementType.$$$reportNull$$$0(7);
        }
        if (psi == null) {
            SqlFileElementType.$$$reportNull$$$0(8);
        }
        Project project = psi.getProject();
        Language hostLanguage = host != null ? SqlPreprocessingLexer.getHostLanguage(host) : (Language)psi.getUserData(HOST_LANGUAGE);
        Lexer lexer = SqlPreprocessingLexer.withPreprocessingIfNeeded(project, parserDefinition, hostLanguage);
        if (lexer == null) {
            SqlFileElementType.$$$reportNull$$$0(9);
        }
        return lexer;
    }

    @Nullable
    private static PsiElement getHostElement(PsiElement psi) {
        PsiLanguageInjectionHost host = InjectedLanguageUtilBase.findInjectionHost((PsiElement)psi);
        if (host == null && !(psi instanceof PsiFile)) {
            host = psi.getParent();
        }
        return host;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chameleon";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerPsi";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parserDefinition";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/stubs/elementTypes/SqlFileElementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/stubs/elementTypes/SqlFileElementType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createLexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doParseContents";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "assertPlainSql";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "dumpPath";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createParser";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createLexer";
                break;
            }
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }
}

