/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.types.DasType;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.impl.SqlExpressionImpl;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPivotColumnDefinition;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.TableBasedSqlTableTypeImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlPivotedQueryExpressionImpl
extends SqlExpressionImpl
implements SqlExpression {
    public SqlPivotedQueryExpressionImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(0);
        }
        super(elementType);
    }

    @Override
    @NotNull
    protected DasType computeDasType() {
        SqlClause columnsClause = this.getColumnsClause();
        SqlClause forClause = (SqlClause)PsiTreeUtil.getNextSiblingOfType((PsiElement)columnsClause, SqlClause.class);
        SqlClause inClause = this.getInClause();
        if (forClause == null || inClause == null) {
            return this.getPivotedExpressionType();
        }
        SqlTableType pivotedType = this.getPivotedType(columnsClause, forClause, inClause);
        SqlTableType restType = this.getRestType(columnsClause, forClause, inClause).alias(null, (PsiElement)this, Collections.emptyList());
        SqlTableType sqlTableType = restType.add(pivotedType);
        if (sqlTableType == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(1);
        }
        return sqlTableType;
    }

    @NotNull
    protected SqlTableType getPivotedType(@NotNull SqlClause columnsClause, @NotNull SqlClause forClause, @NotNull SqlClause inClause) {
        if (columnsClause == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(2);
        }
        if (forClause == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(3);
        }
        if (inClause == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(4);
        }
        List values = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)columnsClause, SqlExpression.class);
        List columns = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)inClause, SqlExpression.class);
        if (values.isEmpty()) {
            SqlTableType sqlTableType = SqlTableTypeBase.EMPTY_TABLE;
            if (sqlTableType == null) {
                SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(5);
            }
            return sqlTableType;
        }
        ArrayList<SqlTypedDefinition> result = new ArrayList<SqlTypedDefinition>(values.size() * columns.size());
        for (PsiElement element : SqlImplUtil.sqlChildren((PsiElement)inClause)) {
            if (element instanceof SqlPivotColumnDefinition) {
                SqlPivotColumnDefinition columnDefinition = (SqlPivotColumnDefinition)element;
                result.add(columnDefinition);
                continue;
            }
            if (!(element instanceof SqlExpression)) continue;
            SqlExpression expression = (SqlExpression)element;
            for (SqlExpression value : values) {
                result.add(this.createFakeColumnDefinition((PsiElement)this, value, expression));
            }
        }
        if (result.isEmpty()) {
            SqlTableType sqlTableType = SqlTableTypeBase.EMPTY_TABLE;
            if (sqlTableType == null) {
                SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(6);
            }
            return sqlTableType;
        }
        return new TableBasedSqlTableTypeImpl(result, (PsiElement)this);
    }

    @NotNull
    protected SqlTableType getRestType(@NotNull SqlClause columnsClause, @NotNull SqlClause forClause, @NotNull SqlClause inClause) {
        if (columnsClause == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(7);
        }
        if (forClause == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(8);
        }
        if (inClause == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(9);
        }
        SqlTableType sqlTableType = this.getRestTypeImpl(columnsClause, forClause);
        if (sqlTableType == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(10);
        }
        return sqlTableType;
    }

    @NotNull
    protected SqlTableType getRestTypeImpl(SqlClause ... clauses) {
        SqlTableType pivotedType = this.getPivotedExpressionType();
        if (pivotedType == SqlTableTypeBase.EMPTY_TABLE) {
            SqlTableType sqlTableType = pivotedType;
            if (sqlTableType == null) {
                SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(11);
            }
            return sqlTableType;
        }
        LinkedHashSet toSubtract = new LinkedHashSet();
        for (SqlReferenceExpression ref : ((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoots((Iterable)JBIterable.of((Object[])clauses))).filter(SqlReferenceExpression.class)) {
            if (SqlImplUtil.isAsteriskRef((PsiElement)ref) || ref.getReferenceElementType().getTargetKind() != ObjectKind.COLUMN) continue;
            for (ResolveResult result : ref.multiResolve(false)) {
                ContainerUtil.addIfNotNull(toSubtract, (Object)result.getElement());
            }
        }
        for (PsiElement element : toSubtract) {
            pivotedType = pivotedType.subtract(element);
        }
        SqlTableType sqlTableType = pivotedType;
        if (sqlTableType == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(12);
        }
        return sqlTableType;
    }

    @NotNull
    private SqlTableType getPivotedExpressionType() {
        SqlTableType tableType2;
        SqlExpression expression = this.getPivotedExpression();
        if (expression == null) {
            SqlTableType sqlTableType = SqlTableTypeBase.EMPTY_TABLE;
            if (sqlTableType == null) {
                SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(13);
            }
            return sqlTableType;
        }
        DasType pivotedType = expression.getDasType();
        SqlTableType sqlTableType = pivotedType instanceof SqlTableType ? (tableType2 = (SqlTableType)pivotedType) : SqlTableTypeBase.EMPTY_TABLE;
        if (sqlTableType == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(14);
        }
        return sqlTableType;
    }

    @Nullable
    protected SqlClause getColumnsClause() {
        return (SqlClause)PsiTreeUtil.getChildOfType((PsiElement)this, SqlClause.class);
    }

    @Nullable
    protected SqlClause getInClause() {
        PsiElement child = this.getLastChild();
        if (child == null || child instanceof SqlClause) {
            return (SqlClause)child;
        }
        return (SqlClause)PsiTreeUtil.getPrevSiblingOfType((PsiElement)child, SqlClause.class);
    }

    @Override
    public boolean processDeclarations(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(15);
        }
        if (state == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(16);
        }
        if (place == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(17);
        }
        SqlExpression expression = this.getPivotedExpression();
        if ((lastParent == null || lastParent.getContext() == this && !PsiTreeUtil.isContextAncestor((PsiElement)expression, (PsiElement)place, (boolean)false)) && expression != null && !SqlImplUtil.processDeclarationsInType(expression, processor, state, place)) {
            return false;
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }

    @Nullable
    private SqlExpression getPivotedExpression() {
        return (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)this, SqlExpression.class);
    }

    @Nullable
    protected String getSimpleFakeColumnName(@NotNull SqlExpression column) {
        if (column == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(18);
        }
        return column.getName();
    }

    @NotNull
    protected String getFullFakeColumnName(@NotNull String columnName, @Nullable String valueName) {
        if (columnName == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(19);
        }
        Object object = valueName != null ? columnName + "_" + valueName : columnName;
        if (object == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(20);
        }
        return object;
    }

    private MyFakeDefinition createFakeColumnDefinition(@NotNull PsiElement parent, @NotNull SqlExpression value, @NotNull SqlExpression column) {
        String vName;
        if (parent == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(21);
        }
        if (value == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(22);
        }
        if (column == null) {
            SqlPivotedQueryExpressionImpl.$$$reportNull$$$0(23);
        }
        boolean columnQuoted = DbSqlUtilCore.isQuoted((DasObject)((DasObject)ObjectUtils.tryCast((Object)column, DasObject.class)));
        boolean valueQuoted = DbSqlUtilCore.isQuoted((DasObject)((DasObject)ObjectUtils.tryCast((Object)value, DasObject.class)));
        String cName = this.getSimpleFakeColumnName(column);
        String string = vName = value instanceof DasObject ? value.getName() : null;
        if (valueQuoted != columnQuoted) {
            SqlLanguageDialectEx language = SqlImplUtil.getSqlDialectSafe(parent);
            Casing casing = language.getCasing(ObjectKind.COLUMN, null);
            if (casing.quoted == Case.EXACT) {
                if (!columnQuoted) {
                    cName = casing.plain.apply(cName);
                }
                if (!valueQuoted) {
                    vName = casing.plain.apply(vName);
                }
            }
        }
        String name = cName == null ? cName : this.getFullFakeColumnName(cName, vName);
        return new MyFakeDefinition(parent, name, columnQuoted || valueQuoted, value, column);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 6, 10, 11, 12, 13, 14, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlPivotedQueryExpressionImpl";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnsClause";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forClause";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inClause";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlPivotedQueryExpressionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDasType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPivotedType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRestType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRestTypeImpl";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPivotedExpressionType";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullFakeColumnName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPivotedType";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRestType";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleFakeColumnName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getFullFakeColumnName";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createFakeColumnDefinition";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 6, 10, 11, 12, 13, 14, 20 -> new IllegalStateException(string);
        };
    }

    private static class MyFakeDefinition
    extends SqlFileImpl.FakeDefinition
    implements SqlTypedDefinition {
        private final boolean myQuoted;
        private final SqlExpression myValue;
        private final SqlExpression myColumn;

        MyFakeDefinition(@NotNull PsiElement parent, @Nullable String name, boolean quoted, @NotNull SqlExpression value, @NotNull SqlExpression column) {
            if (parent == null) {
                MyFakeDefinition.$$$reportNull$$$0(0);
            }
            if (value == null) {
                MyFakeDefinition.$$$reportNull$$$0(1);
            }
            if (column == null) {
                MyFakeDefinition.$$$reportNull$$$0(2);
            }
            super(parent, StringUtil.notNullize((String)name));
            this.myQuoted = quoted;
            this.myValue = value;
            this.myColumn = column;
        }

        @Override
        @NotNull
        public Dbms getDbms() {
            Dbms dbms = super.getDbms();
            if (dbms == null) {
                MyFakeDefinition.$$$reportNull$$$0(3);
            }
            return dbms;
        }

        public boolean isNameQuoted() {
            return this.myQuoted;
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.COLUMN;
            if (objectKind == null) {
                MyFakeDefinition.$$$reportNull$$$0(4);
            }
            return objectKind;
        }

        @NotNull
        public PsiElement getNavigationElement() {
            SqlExpression sqlExpression = this.myColumn;
            if (sqlExpression == null) {
                MyFakeDefinition.$$$reportNull$$$0(5);
            }
            return sqlExpression;
        }

        @Nullable
        public SqlTypeElement getTypeElement() {
            return null;
        }

        @NotNull
        public DasType getDasType() {
            DasType dasType = this.myValue.getDasType();
            if (dasType == null) {
                MyFakeDefinition.$$$reportNull$$$0(6);
            }
            return dasType;
        }

        public boolean isNotNull() {
            return false;
        }

        @Nullable
        public String getDefault() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/psi/impl/SqlPivotedQueryExpressionImpl$MyFakeDefinition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/psi/impl/SqlPivotedQueryExpressionImpl$MyFakeDefinition";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDbms";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationElement";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDasType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5, 6 -> new IllegalStateException(string);
            };
        }
    }
}

