/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.config.hints;

import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.microservices.jvm.config.ConfigKeyPathUtils;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MicroservicesConfigBundle;
import com.intellij.microservices.jvm.config.hints.HintReferenceBase;
import com.intellij.microservices.jvm.config.hints.HintReferenceProviderBase;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReference;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumHintReferenceProvider
extends HintReferenceProviderBase {
    private final PsiClass myEnumClass;
    private final boolean myLowerCase;

    public EnumHintReferenceProvider(PsiClass enumClass) {
        this(enumClass, true);
    }

    public EnumHintReferenceProvider(PsiClass enumClass, boolean lowerCase) {
        this.myEnumClass = enumClass;
        this.myLowerCase = lowerCase;
    }

    protected List<String> getRelaxedVariants(@NotNull String value) {
        if (value == null) {
            EnumHintReferenceProvider.$$$reportNull$$$0(0);
        }
        return ConfigKeyPathUtils.getEnumReferenceVariants(value);
    }

    protected String getEnumValueName(PsiField psiField) {
        return StringUtil.defaultIfEmpty((String)psiField.getName(), (String)"<invalid>");
    }

    @Override
    @NotNull
    protected PsiReference createReference(PsiElement element, TextRange textRange, ProcessingContext context) {
        return new HintReferenceBase(element, textRange){

            @Override
            public TextAttributesKey getTextAttributesKey() {
                return DefaultLanguageHighlighterColors.STATIC_FIELD;
            }

            @Override
            @Nullable
            protected PsiElement doResolve() {
                return ConfigKeyPathUtils.resolveEnumReference(EnumHintReferenceProvider.this.getRelaxedVariants(this.getValue()), EnumHintReferenceProvider.this.myEnumClass, EnumHintReferenceProvider.this.myLowerCase);
            }

            @Override
            public Object @NotNull [] getHintVariants() {
                Object[] objectArray = ContainerUtil.map2Array((Object[])this.getEnumFields(), LookupElement.class, field -> {
                    String name = EnumHintReferenceProvider.this.getEnumValueName((PsiField)field);
                    String lookupString = EnumHintReferenceProvider.this.myLowerCase ? StringUtil.toLowerCase((String)name) : name;
                    LookupElementBuilder builder = JavaLookupElementBuilder.forField((PsiField)field, (String)lookupString, null);
                    String shortDoc = 1.getEnumFieldShortJavadoc(field);
                    if (shortDoc == null) {
                        return builder;
                    }
                    return builder.withTailText(" (" + shortDoc + ")", true);
                });
                if (objectArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return objectArray;
            }

            @Override
            @NotNull
            public String getUnresolvedMessagePattern() {
                String string = MicroservicesConfigBundle.partialMessage("config.unresolved.enum.value", 1, EnumHintReferenceProvider.this.myEnumClass.getQualifiedName());
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Nullable
            private static String getEnumFieldShortJavadoc(PsiField field) {
                PsiElement navigationElement = field.getNavigationElement();
                if (!(navigationElement instanceof PsiDocCommentOwner)) {
                    return null;
                }
                PsiDocComment comment = ((PsiDocCommentOwner)navigationElement).getDocComment();
                if (comment == null) {
                    return null;
                }
                StringBuilder sb = new StringBuilder();
                for (PsiElement element : comment.getDescriptionElements()) {
                    sb.append(StringUtil.replaceUnicodeEscapeSequences((String)element.getText()));
                }
                String plainJavadoc = sb.toString();
                if (StringUtil.isEmptyOrSpaces((String)plainJavadoc)) {
                    return null;
                }
                String strippedDoc = StringUtil.stripHtml((String)StringUtil.trim((String)plainJavadoc), (boolean)false);
                MetaConfigKey.DescriptionText text = new MetaConfigKey.DescriptionText(strippedDoc);
                return text.getShortText();
            }

            private PsiField @NotNull [] getEnumFields() {
                PsiField[] psiFieldArray = (PsiField[])ContainerUtil.findAllAsArray((Object[])EnumHintReferenceProvider.this.myEnumClass.getFields(), (Condition)Conditions.instanceOf(PsiEnumConstant.class));
                if (psiFieldArray == null) {
                    1.$$$reportNull$$$0(2);
                }
                return psiFieldArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/microservices/jvm/config/hints/EnumHintReferenceProvider$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getHintVariants";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getUnresolvedMessagePattern";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getEnumFields";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/microservices/jvm/config/hints/EnumHintReferenceProvider", "getRelaxedVariants"));
    }
}

