/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.re.ui;

import com.intellij.icons.AllIcons;
import com.intellij.jpa.jpb.model.JpaIcons;
import com.intellij.jpa.jpb.model.backend.ed.indexing.CustomTypeModel;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.model.Datatype;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttributeModel;
import com.intellij.jpa.jpb.model.model.EntityModel;
import com.intellij.jpa.jpb.model.model.EntityPsi;
import com.intellij.jpa.jpb.model.ui.JpbColor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.util.ClassUtil;
import com.intellij.re.ui.AttrMappingType;
import com.intellij.re.ui.DbColumnTreeNode;
import com.intellij.re.ui.DbColumnsTable;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JTable;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J:\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0014J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\fH\u0003J\"\u0010\u001a\u001a\u00020\u00052\b\u0010\u001b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/re/ui/JavaTypeCellRender;", "Lcom/intellij/ui/ColoredTableCellRenderer;", "project", "Lcom/intellij/openapi/project/Project;", "isAbilityToEditAssociation", "", "<init>", "(Lcom/intellij/openapi/project/Project;Z)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "newClassMap", "", "", "customizeCellRenderer", "", "table", "Ljavax/swing/JTable;", "value", "", "selected", "hasFocus", "row", "", "column", "extractClassName", "fqn", "isNewAttrModelType", "typeFqn", "selectedColumn", "Lcom/intellij/re/ui/DbColumnTreeNode;", "attribute", "Lcom/intellij/jpa/jpb/model/model/EntityAttributeModel;", "intellij.javaee.reverseEngineering"})
@SourceDebugExtension(value={"SMAP\nDbColumnsModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbColumnsModel.kt\ncom/intellij/re/ui/JavaTypeCellRender\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,805:1\n382#2,7:806\n*S KotlinDebug\n*F\n+ 1 DbColumnsModel.kt\ncom/intellij/re/ui/JavaTypeCellRender\n*L\n542#1:806,7\n*E\n"})
public final class JavaTypeCellRender
extends ColoredTableCellRenderer {
    @NotNull
    private final Project project;
    private final boolean isAbilityToEditAssociation;
    @NotNull
    private final Map<String, Boolean> newClassMap;

    public JavaTypeCellRender(@NotNull Project project, boolean isAbilityToEditAssociation) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.isAbilityToEditAssociation = isAbilityToEditAssociation;
        this.newClassMap = new LinkedHashMap();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Object object = table instanceof DbColumnsTable ? (DbColumnsTable)((Object)table) : null;
        if (object == null || (object = object.getDbColumn(row)) == null) {
            return;
        }
        Object selectedColumn = object;
        AttrMappingType attrMappingType = ((DbColumnTreeNode)((Object)selectedColumn)).getAttrMappingType();
        if (attrMappingType == AttrMappingType.Todo) {
            this.append(JpaModelBundle.message((String)"todo.java.type.render", (Object[])new Object[0]), new SimpleTextAttributes(0, JpbColor.YELLOW));
            return;
        }
        EntityAttributeModel attribute = ((DbColumnTreeNode)((Object)selectedColumn)).getAttribute();
        CustomTypeModel converter = attribute.getConverter();
        if (attrMappingType == AttrMappingType.Basic && converter != null) {
            icon = JpaIcons.Converter;
        } else {
            AttrMappingType attrMappingType2 = attrMappingType;
            icon = (attrMappingType2 != null ? attrMappingType2.isAssociation() : false) ? JpaIcons.Relationship : (attribute.isEmbedded() && !attribute.isId() ? JpaIcons.Embeddable : (attrMappingType == AttrMappingType.Enum ? AllIcons.Nodes.Enum : (attribute.isId() ? JpaIcons.AttributeId : JpaIcons.StandardBasic)));
        }
        this.setIcon(icon);
        Object unmappedColumnsInfo = attribute.getAdditionalProperties().get("unmappedColumn");
        Object object2 = value;
        String javaTypeFqn = object2 != null ? object2.toString() : null;
        CharSequence charSequence = javaTypeFqn;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            String className = this.extractClassName(javaTypeFqn);
            if (converter != null) {
                this.append(className + " -> " + attribute.getType().getClassName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            } else {
                SimpleTextAttributes textAttributes = this.isNewAttrModelType(javaTypeFqn, (DbColumnTreeNode)((Object)selectedColumn), attribute) ? new SimpleTextAttributes(0, JpbColor.GREEN) : SimpleTextAttributes.REGULAR_ATTRIBUTES;
                this.append(className, textAttributes);
                if (!StringsKt.contains$default((CharSequence)className, (char)'<', (boolean)false, (int)2, null)) {
                    AttrMappingType attrMappingType3 = attrMappingType;
                    boolean bl = attrMappingType3 != null ? !attrMappingType3.isAssociation() : false;
                    if (bl || this.isAbilityToEditAssociation || !(attribute.getType() instanceof EntityModel)) {
                        this.append(" " + ClassUtil.extractPackageName((String)javaTypeFqn), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    }
                }
            }
        } else {
            Object v = unmappedColumnsInfo;
            if (v == null || (v = v.toString()) == null) {
                v = "";
            }
            this.append((String)v, SimpleTextAttributes.ERROR_ATTRIBUTES);
        }
    }

    @NlsSafe
    private final String extractClassName(String fqn) {
        if (!StringsKt.contains$default((CharSequence)fqn, (char)'<', (boolean)false, (int)2, null) || !StringsKt.contains$default((CharSequence)fqn, (char)'>', (boolean)false, (int)2, null)) {
            String string = ClassUtil.extractClassName((String)fqn);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extractClassName(...)");
            return string;
        }
        String classFqn = StringsKt.substringBefore$default((String)fqn, (char)'<', null, (int)2, null);
        String genericValue = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)fqn, (char)'<', null, (int)2, null), (char)'>', null, (int)2, null);
        char[] cArray = new char[]{','};
        String shortenGenericValue = CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)genericValue, (char[])cArray, (boolean)false, (int)0, (int)6, null), (CharSequence)", ", null, null, (int)0, null, JavaTypeCellRender::extractClassName$lambda$0, (int)30, null);
        return ClassUtil.extractClassName((String)classFqn) + "<" + shortenGenericValue + ">";
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isNewAttrModelType(String typeFqn, DbColumnTreeNode selectedColumn, EntityAttributeModel attribute) {
        Object object;
        void $this$getOrPut$iv;
        Datatype attrType = attribute.getType();
        Object object2 = typeFqn;
        if (object2 == null || StringsKt.isBlank((CharSequence)object2) || selectedColumn.getAttrMappingType() == AttrMappingType.Basic && (!attribute.isId() || !(attrType instanceof Entity)) || attrType instanceof EntityPsi) {
            return false;
        }
        object2 = this.newClassMap;
        String key$iv = typeFqn;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Boolean answer$iv = !selectedColumn.isJavaTypeExists();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Boolean)object;
    }

    private static final CharSequence extractClassName$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = ClassUtil.extractClassName((String)((Object)StringsKt.trim((CharSequence)it)).toString());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extractClassName(...)");
        return string;
    }
}

