/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.platform.ide.progress.TasksKt;
import git4idea.GitBranch;
import git4idea.GitDisposable;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.GitUtil;
import git4idea.branch.GitBranchPair;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitNewBranchDialog;
import git4idea.branch.GitNewBranchOptions;
import git4idea.config.GitVcsSettings;
import git4idea.fetch.GitFetchSpec;
import git4idea.fetch.GitFetchSupport;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitBranchCheckoutOperation;
import git4idea.update.GitUpdateExecutionProcess;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a<\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0003\u0010\t\u001a\u00020\b2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\bH\u0001\u001a,\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rH\u0000\u001a$\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\r2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0000\u001a\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a$\u0010\u0012\u001a\u00020\u000f2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\bH\u0000\u00a8\u0006\u0017"}, d2={"createOrCheckoutNewBranch", "", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "startPoint", "", "title", "initialName", "updateBranches", "localBranchNames", "", "isTrackingInfosExist", "", "branchNames", "hasRemotes", "hasTrackingConflicts", "conflictingLocalBranches", "", "Lgit4idea/GitLocalBranch;", "remoteBranchName", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitBranchActionsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitBranchActionsUtil.kt\ngit4idea/ui/branch/GitBranchActionsUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,123:1\n1285#2,2:124\n1299#2,2:126\n774#2:128\n865#2,2:129\n1302#2:131\n1374#2:132\n1460#2,5:133\n1761#2,3:138\n1761#2,3:141\n188#3,3:144\n*S KotlinDebug\n*F\n+ 1 GitBranchActionsUtil.kt\ngit4idea/ui/branch/GitBranchActionsUtilKt\n*L\n44#1:124,2\n44#1:126,2\n44#1:128\n44#1:129,2\n44#1:131\n93#1:132\n93#1:133,5\n94#1:138,3\n97#1:141,3\n102#1:144,3\n*E\n"})
public final class GitBranchActionsUtilKt {
    @JvmOverloads
    public static final void createOrCheckoutNewBranch(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories, @NotNull String startPoint, @Nls(capitalization=Nls.Capitalization.Title) @NotNull String title, @Nullable String initialName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)startPoint, (String)"startPoint");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        GitNewBranchOptions gitNewBranchOptions = new GitNewBranchDialog(project, repositories, title, initialName, false, true, false, false, true, null, 720, null).showAndGetOptions();
        if (gitNewBranchOptions == null) {
            return;
        }
        GitNewBranchOptions options = gitNewBranchOptions;
        new GitBranchCheckoutOperation(project, options.repositories()).perform(startPoint, options);
    }

    public static /* synthetic */ void createOrCheckoutNewBranch$default(Project project, Collection collection, String string, String string2, String string3, int n, Object object) {
        if ((n & 8) != 0) {
            String string4 = GitBundle.message((String)"branches.create.new.branch.dialog.title", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
            string2 = string4;
        }
        if ((n & 0x10) != 0) {
            string3 = null;
        }
        GitBranchActionsUtilKt.createOrCheckoutNewBranch(project, collection, string, string2, string3);
    }

    /*
     * WARNING - void declaration
     */
    public static final void updateBranches(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories, @NotNull List<String> localBranchNames) {
        void $this$associateWithTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter(localBranchNames, (String)"localBranchNames");
        Iterable $this$associateWith$iv = repositories;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable iterable = $this$associateWith$iv;
        Map destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$filterTo$iv$iv;
            void it;
            GitRepository gitRepository = (GitRepository)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Collection<GitBranchTrackInfo> collection = it.getBranchTrackInfos();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getBranchTrackInfos(...)");
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                GitBranchTrackInfo info = (GitBranchTrackInfo)element$iv$iv2;
                boolean bl2 = false;
                if (!localBranchNames.contains(info.getLocalBranch().getName())) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            List list = (List)destination$iv$iv2;
            map2.put(t, list);
        }
        Map repoToTrackingInfos = destination$iv$iv;
        if (repoToTrackingInfos.isEmpty()) {
            return;
        }
        BuildersKt.launch$default((CoroutineScope)GitDisposable.Companion.getInstance(project).getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, (Map<GitRepository, ? extends List<? extends GitBranchTrackInfo>>)repoToTrackingInfos, repositories, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ Map<GitRepository, List<GitBranchTrackInfo>> $repoToTrackingInfos;
            final /* synthetic */ Collection<GitRepository> $repositories;
            {
                this.$project = $project;
                this.$repoToTrackingInfos = $repoToTrackingInfos;
                this.$repositories = $repositories;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        String string = GitBundle.message((String)"branches.updating.process", (Object[])new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        this.label = 1;
                        Object object2 = TasksKt.withBackgroundProgress((Project)this.$project, (String)string, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$repoToTrackingInfos, this.$project, this.$repositories, null){
                            Object L$0;
                            Object L$1;
                            int label;
                            final /* synthetic */ Map<GitRepository, List<GitBranchTrackInfo>> $repoToTrackingInfos;
                            final /* synthetic */ Project $project;
                            final /* synthetic */ Collection<GitRepository> $repositories;
                            {
                                this.$repoToTrackingInfos = $repoToTrackingInfos;
                                this.$project = $project;
                                this.$repositories = $repositories;
                                super(2, $completion);
                            }

                            /*
                             * Could not resolve type clashes
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var15_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        updateProcessTargets = new HashMap();
                                        fetchTargets = new ArrayList<E>();
                                        for (Object[] var5_9 : this.$repoToTrackingInfos.entrySet()) {
                                            repo = var5_9.getKey();
                                            trackingInfos = (List)var5_9.getValue();
                                            currentBranch = repo.getCurrentBranch();
                                            for (GitBranchTrackInfo trackingInfo : trackingInfos) {
                                                Intrinsics.checkNotNullExpressionValue((Object)trackingInfo.getLocalBranch(), (String)"getLocalBranch(...)");
                                                Intrinsics.checkNotNullExpressionValue((Object)trackingInfo.getRemoteBranch(), (String)"getRemoteBranch(...)");
                                                if (Intrinsics.areEqual((Object)localBranch, (Object)currentBranch)) {
                                                    ((Map)updateProcessTargets).put(repo, new GitBranchPair(currentBranch, (GitBranch)remoteBranch));
                                                    continue;
                                                }
                                                localBranchName = localBranch.getName();
                                                remoteBranchName = remoteBranch.getNameForRemoteOperations();
                                                v0 = trackingInfo.getRemote();
                                                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getRemote(...)");
                                                Boxing.boxBoolean((boolean)fetchTargets.add(new GitFetchSpec(repo, v0, remoteBranchName + ":" + localBranchName, false, null, 24, null)));
                                            }
                                        }
                                        if (!(((Collection)fetchTargets).isEmpty() == false)) ** GOTO lbl43
                                        this.L$0 = updateProcessTargets;
                                        this.L$1 = fetchTargets;
                                        this.label = 1;
                                        v1 = CoroutinesKt.coroutineToIndicator((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$0(com.intellij.openapi.project.Project java.util.List com.intellij.openapi.progress.ProgressIndicator ), (Lcom/intellij/openapi/progress/ProgressIndicator;)Ljava/lang/Boolean;)((Project)this.$project, (List)fetchTargets), (Continuation)((Continuation)this));
                                        if (v1 == var15_2) {
                                            return var15_2;
                                        }
                                        ** GOTO lbl39
                                    }
                                    case 1: {
                                        fetchTargets = (List)this.L$1;
                                        updateProcessTargets = (HashMap)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
lbl39:
                                        // 2 sources

                                        if (fetchSuccessful = ((Boolean)v1).booleanValue()) {
                                            var5_9 = new Object[]{Boxing.boxInt((int)fetchTargets.size())};
                                            VcsNotifier.getInstance((Project)this.$project).notifySuccess("git.branches.update.successful", "", GitBundle.message((String)"branches.fetch.finished", (Object[])var5_9));
                                        }
lbl43:
                                        // 4 sources

                                        if (((Map)updateProcessTargets).isEmpty() == false) {
                                            v2 = updateProcessTargets;
                                            v3 = GitVcsSettings.getInstance((Project)this.$project).getUpdateMethod();
                                            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getUpdateMethod(...)");
                                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)updateProcessTargets);
                                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)fetchTargets);
                                            this.label = 2;
                                            v4 = GitUpdateExecutionProcess.INSTANCE.update(this.$project, this.$repositories, v2, v3, false, (Continuation<? super Unit>)((Continuation)this));
                                            if (v4 == var15_2) {
                                                return var15_2;
                                            }
                                        }
                                        ** GOTO lbl59
                                    }
                                    case 2: {
                                        fetchTargets = (List)this.L$1;
                                        updateProcessTargets = (HashMap)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v4 = $result;
lbl59:
                                        // 2 sources

                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }

                            private static final boolean invokeSuspend$lambda$0(Project $project, List $fetchTargets, ProgressIndicator it) {
                                return GitFetchSupport.fetchSupport($project).fetch($fetchTargets).showNotificationIfFailed(GitBundle.message((String)"branches.update.failed", (Object[])new Object[0]));
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isTrackingInfosExist(@NotNull List<String> branchNames, @NotNull Collection<? extends GitRepository> repositories) {
        boolean bl;
        block8: {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter(branchNames, (String)"branchNames");
            Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
            Iterable $this$flatMap$iv = repositories;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                GitRepository p0 = (GitRepository)element$iv$iv;
                boolean bl2 = false;
                Iterable list$iv$iv = p0.getBranchTrackInfos();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl3;
                    block7: {
                        GitBranchTrackInfo trackingBranchInfo = (GitBranchTrackInfo)element$iv;
                        boolean bl4 = false;
                        Iterable $this$any$iv2 = branchNames;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                String branchName = (String)element$iv2;
                                boolean bl5 = false;
                                if (!Intrinsics.areEqual((Object)branchName, (Object)trackingBranchInfo.getLocalBranch().getName())) continue;
                                bl3 = true;
                                break block7;
                            }
                            bl3 = false;
                        }
                    }
                    if (!bl3) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean hasRemotes(@NotNull Project project) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Collection<GitRepository> collection = GitUtil.getRepositories(project);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getRepositories(...)");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GitRepository repository2 = (GitRepository)element$iv;
                    boolean bl2 = false;
                    if (!(!repository2.getRemotes().isEmpty())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean hasTrackingConflicts(@NotNull Map<GitRepository, GitLocalBranch> conflictingLocalBranches, @NotNull String remoteBranchName) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(conflictingLocalBranches, (String)"conflictingLocalBranches");
            Intrinsics.checkNotNullParameter((Object)remoteBranchName, (String)"remoteBranchName");
            Map<GitRepository, GitLocalBranch> $this$any$iv = conflictingLocalBranches;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator<Map.Entry<GitRepository, GitLocalBranch>> iterator = $this$any$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    GitLocalBranch branch;
                    Map.Entry<GitRepository, GitLocalBranch> element$iv;
                    Map.Entry<GitRepository, GitLocalBranch> entry = element$iv = iterator.next();
                    boolean bl2 = false;
                    GitRepository repo = entry.getKey();
                    GitBranchTrackInfo trackInfo = GitBranchUtil.getTrackInfoForBranch(repo, branch = entry.getValue());
                    if (!(trackInfo != null && !GitReference.BRANCH_NAME_HASHING_STRATEGY.equals((Object)remoteBranchName, (Object)trackInfo.getRemoteBranch().getName()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @JvmOverloads
    public static final void createOrCheckoutNewBranch(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories, @NotNull String startPoint, @Nls(capitalization=Nls.Capitalization.Title) @NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)startPoint, (String)"startPoint");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        GitBranchActionsUtilKt.createOrCheckoutNewBranch$default(project, repositories, startPoint, title, null, 16, null);
    }

    @JvmOverloads
    public static final void createOrCheckoutNewBranch(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories, @NotNull String startPoint) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)startPoint, (String)"startPoint");
        GitBranchActionsUtilKt.createOrCheckoutNewBranch$default(project, repositories, startPoint, null, null, 24, null);
    }
}

