/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.remote.projectView;

import com.intellij.ide.projectView.ViewSettings;
import com.intellij.jupyter.core.jupyter.remote.projectView.node.JupyterRemoteServerNode;
import com.intellij.notebooks.core.remote.JupyterRemotePath;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\nJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/jupyter/core/jupyter/remote/projectView/JupyterRemoteAuthorityNodeCache;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "cache", "", "", "Lcom/intellij/jupyter/core/jupyter/remote/projectView/node/JupyterRemoteServerNode;", "getOrCreateRootServerNode", "authorityName", "settings", "Lcom/intellij/ide/projectView/ViewSettings;", "getCachedRootServerNode", "forgetServerNode", "", "intellij.jupyter.core"})
public final class JupyterRemoteAuthorityNodeCache {
    @NotNull
    private final Project project;
    @NotNull
    private final Map<String, JupyterRemoteServerNode> cache;

    public JupyterRemoteAuthorityNodeCache(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.cache = new LinkedHashMap();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final JupyterRemoteServerNode getOrCreateRootServerNode(@NotNull String authorityName, @Nullable ViewSettings settings) {
        Intrinsics.checkNotNullParameter((Object)authorityName, (String)"authorityName");
        JupyterRemoteServerNode jupyterRemoteServerNode = this.cache.computeIfAbsent(authorityName, arg_0 -> JupyterRemoteAuthorityNodeCache.getOrCreateRootServerNode$lambda$1(arg_0 -> JupyterRemoteAuthorityNodeCache.getOrCreateRootServerNode$lambda$0(this, authorityName, settings, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)((Object)jupyterRemoteServerNode), (String)"computeIfAbsent(...)");
        return jupyterRemoteServerNode;
    }

    @Nullable
    public final JupyterRemoteServerNode getCachedRootServerNode(@NotNull String authorityName) {
        Intrinsics.checkNotNullParameter((Object)authorityName, (String)"authorityName");
        return this.cache.get(authorityName);
    }

    public final void forgetServerNode(@NotNull String authorityName) {
        Intrinsics.checkNotNullParameter((Object)authorityName, (String)"authorityName");
        this.cache.remove(authorityName);
    }

    private static final JupyterRemoteServerNode getOrCreateRootServerNode$lambda$0(JupyterRemoteAuthorityNodeCache this$0, String $authorityName, ViewSettings $settings, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new JupyterRemoteServerNode(this$0.project, JupyterRemotePath.Companion.getAuthority($authorityName), $settings);
    }

    private static final JupyterRemoteServerNode getOrCreateRootServerNode$lambda$1(Function1 $tmp0, Object p0) {
        return (JupyterRemoteServerNode)((Object)$tmp0.invoke(p0));
    }
}

