/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.nbformat.schema.v3;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.jupyter.core.JupyterJsonKt;
import com.intellij.jupyter.core.jupyter.nbformat.DisplayDataContainer;
import com.intellij.jupyter.core.jupyter.nbformat.JacksonUtil;
import com.intellij.jupyter.core.jupyter.nbformat.MimeType;
import com.intellij.jupyter.core.jupyter.nbformat.schema.DisplayDataContainerBase;
import com.intellij.jupyter.core.jupyter.nbformat.schema.v3.V3DisplayDataContainerKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0016\u0010\u001d\u001a\u0010\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u000b0\u000b0\u001eH\u0002J\b\u0010'\u001a\u00020\u0004H\u0016J\u0012\u0010(\u001a\u0004\u0018\u00010\u000b2\u0006\u0010)\u001a\u00020\u000bH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0016\u0010$\u001a\u0004\u0018\u00010\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006*"}, d2={"Lcom/intellij/jupyter/core/jupyter/nbformat/schema/v3/V3DisplayDataContainer;", "Lcom/intellij/jupyter/core/jupyter/nbformat/DisplayDataContainer;", "Lcom/intellij/jupyter/core/jupyter/nbformat/schema/DisplayDataContainerBase;", "json", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "<init>", "(Lcom/fasterxml/jackson/databind/node/ObjectNode;)V", "getJson", "()Lcom/fasterxml/jackson/databind/node/ObjectNode;", "dataTypeToMimeType", "", "", "mimeTypeToDataType", "getAsMultiline", "", "mimeType", "getAsJsonNode", "Lcom/fasterxml/jackson/databind/JsonNode;", "setAsJsonNode", "", "value", "has", "", "getNode", "getNameToUpdate", "size", "", "getSize", "()I", "dataFields", "Lkotlin/sequences/Sequence;", "kotlin.jvm.PlatformType", "items", "", "getItems", "()Ljava/lang/Iterable;", "textPlain", "getTextPlain", "()Ljava/lang/String;", "toV4Json", "toMimeType", "dataType", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nV3DisplayDataContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 V3DisplayDataContainer.kt\ncom/intellij/jupyter/core/jupyter/nbformat/schema/v3/V3DisplayDataContainer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n1193#2,2:84\n1267#2,4:86\n1374#2:90\n1460#2,2:91\n1563#2:93\n1634#2,3:94\n1462#2,3:97\n1#3:100\n*S KotlinDebug\n*F\n+ 1 V3DisplayDataContainer.kt\ncom/intellij/jupyter/core/jupyter/nbformat/schema/v3/V3DisplayDataContainer\n*L\n30#1:84,2\n30#1:86,4\n31#1:90\n31#1:91,2\n31#1:93\n31#1:94,3\n31#1:97,3\n*E\n"})
public final class V3DisplayDataContainer
extends DisplayDataContainerBase
implements DisplayDataContainer {
    @NotNull
    private final ObjectNode json;
    @NotNull
    private final Map<String, String> dataTypeToMimeType;
    @NotNull
    private final Map<String, String> mimeTypeToDataType;
    private final int size;

    /*
     * WARNING - void declaration
     */
    public V3DisplayDataContainer(@NotNull ObjectNode json) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.json = json;
        Object object = new Pair[9];
        object[0] = TuplesKt.to((Object)"text", (Object)CollectionsKt.listOf((Object)"text/plain"));
        object[1] = TuplesKt.to((Object)"latex", (Object)CollectionsKt.listOf((Object)"application/x-tex"));
        object[2] = TuplesKt.to((Object)"png", (Object)CollectionsKt.listOf((Object)"image/png"));
        object[3] = TuplesKt.to((Object)"jpeg", (Object)CollectionsKt.listOf((Object)"image/jpeg"));
        object[4] = TuplesKt.to((Object)"svg", (Object)CollectionsKt.listOf((Object)"image/svg+xml"));
        object[5] = TuplesKt.to((Object)"html", (Object)CollectionsKt.listOf((Object)"text/html"));
        object[6] = TuplesKt.to((Object)"pdf", (Object)CollectionsKt.listOf((Object)"application/pdf"));
        Object[] objectArray = new String[]{"text/javascript", "application/javascript"};
        object[7] = TuplesKt.to((Object)"javascript", (Object)CollectionsKt.listOf((Object[])objectArray));
        object[8] = TuplesKt.to((Object)"json", (Object)CollectionsKt.listOf((Object)"application/json"));
        List mappings = CollectionsKt.listOf((Object[])object);
        object = mappings;
        V3DisplayDataContainer v3DisplayDataContainer = this;
        boolean $i$f$associate = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var6_9 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv2 : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Pair it = (Pair)element$iv$iv2;
            boolean bl = false;
            it = TuplesKt.to((Object)it.getFirst(), (Object)CollectionsKt.first((List)((List)it.getSecond())));
            map.put(it.getFirst(), it.getSecond());
        }
        v3DisplayDataContainer.dataTypeToMimeType = destination$iv$iv;
        $this$associate$iv = mappings;
        v3DisplayDataContainer = this;
        boolean $i$f$flatMap = false;
        void capacity$iv22 = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            Object element$iv$iv2;
            element$iv$iv2 = (Pair)element$iv$iv;
            boolean bl = false;
            String dataType = (String)element$iv$iv2.component1();
            List mimeTypes = (List)element$iv$iv2.component2();
            Iterable $this$map$iv = mimeTypes;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv3;
                boolean bl2 = false;
                collection.add(TuplesKt.to((Object)it, (Object)dataType));
            }
            Iterable list$iv$iv = (List)destination$iv$iv3;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        v3DisplayDataContainer.mimeTypeToDataType = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
        this.size = SequencesKt.count(this.dataFields());
    }

    @Override
    @NotNull
    public ObjectNode getJson() {
        return this.json;
    }

    @Override
    @Nullable
    public List<String> getAsMultiline(@NotNull String mimeType) {
        List<String> list;
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        JsonNode jsonNode = this.getNode(mimeType);
        if (jsonNode != null) {
            JsonNode it = jsonNode;
            boolean bl = false;
            list = this.getMultiline(it);
        } else {
            list = null;
        }
        return list;
    }

    @Override
    @Nullable
    public JsonNode getAsJsonNode(@NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        return this.getNode(mimeType);
    }

    @Override
    public void setAsJsonNode(@NotNull String mimeType, @Nullable JsonNode value) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        String name = this.getNameToUpdate(mimeType);
        JsonNode jsonNode = value != null ? this.getJson().set(name, value) : this.getJson().remove(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean has(@NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        if (this.getJson().has(mimeType)) return true;
        String string = this.mimeTypeToDataType.get(mimeType);
        if (string == null) return false;
        String it = string;
        boolean bl = false;
        boolean bl2 = this.getJson().has(it);
        if (!bl2) return false;
        return true;
    }

    private final JsonNode getNode(String mimeType) {
        JsonNode jsonNode = this.getJson().get(mimeType);
        if (jsonNode == null) {
            String string = this.mimeTypeToDataType.get(mimeType);
            if (string != null) {
                String it = string;
                boolean bl = false;
                jsonNode = this.getJson().get(it);
            } else {
                jsonNode = null;
            }
        }
        return jsonNode;
    }

    private final String getNameToUpdate(String mimeType) {
        String string;
        block3: {
            block2: {
                String string2;
                string = this.mimeTypeToDataType.get(mimeType);
                if (string == null) break block2;
                String it = string2 = string;
                boolean bl = false;
                string = this.getJson().has(it) ? string2 : null;
                if (string != null) break block3;
            }
            string = mimeType;
        }
        return string;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    private final Sequence<String> dataFields() {
        Iterator iterator = this.getJson().fieldNames();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"fieldNames(...)");
        return SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)iterator), V3DisplayDataContainer::dataFields$lambda$0);
    }

    @Override
    @NotNull
    public Iterable<String> getItems() {
        Iterator iterator = this.getJson().fieldNames();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"fieldNames(...)");
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)iterator), V3DisplayDataContainer::_get_items_$lambda$0), arg_0 -> V3DisplayDataContainer._get_items_$lambda$1(this, arg_0)));
    }

    @Override
    @Nullable
    public String getTextPlain() {
        return JacksonUtil.INSTANCE.getMime(this.getJson(), MimeType.TEXT_PLAIN);
    }

    @Override
    @NotNull
    public ObjectNode toV4Json() {
        ObjectNode objectNode;
        ObjectNode $this$toV4Json_u24lambda_u240 = objectNode = JupyterJsonKt.getJackson().createObjectNode();
        boolean bl = false;
        for (String field : this.dataFields()) {
            String string;
            Intrinsics.checkNotNull((Object)field);
            if (this.toMimeType(field) == null) continue;
            String it = string;
            boolean bl2 = false;
            $this$toV4Json_u24lambda_u240.set(it, this.getJson().get(field));
        }
        ObjectNode objectNode2 = objectNode;
        Intrinsics.checkNotNullExpressionValue((Object)objectNode2, (String)"apply(...)");
        return objectNode2;
    }

    private final String toMimeType(String dataType) {
        return !StringsKt.contains$default((CharSequence)dataType, (CharSequence)"/", (boolean)false, (int)2, null) ? this.dataTypeToMimeType.get(dataType) : dataType;
    }

    private static final boolean dataFields$lambda$0(String it) {
        return !V3DisplayDataContainerKt.access$getKnownProperties$p().contains(it);
    }

    private static final boolean _get_items_$lambda$0(String dataType) {
        return !V3DisplayDataContainerKt.access$getKnownProperties$p().contains(dataType);
    }

    private static final String _get_items_$lambda$1(V3DisplayDataContainer this$0, String dataType) {
        Intrinsics.checkNotNull((Object)dataType);
        return !StringsKt.contains$default((CharSequence)dataType, (CharSequence)"/", (boolean)false, (int)2, null) ? this$0.toMimeType(dataType) : dataType;
    }
}

