/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.debugger.common;

import com.intellij.jupyter.core.jupyter.debugger.common.JupyterDebugSessionPath;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u0006J\u0006\u0010\u000f\u001a\u00020\bJ\b\u0010\u0010\u001a\u00020\nH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/jupyter/core/jupyter/debugger/common/JupyterDebugSessionManager;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "runningSessions", "", "Lcom/intellij/jupyter/core/jupyter/debugger/common/JupyterDebugSessionPath;", "executorService", "Ljava/util/concurrent/ExecutorService;", "debugInSessionStarted", "", "path", "debugInSessionFinished", "isSessionUnderDebug", "", "getExecutorService", "dispose", "Companion", "intellij.jupyter.core"})
public final class JupyterDebugSessionManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<JupyterDebugSessionPath> runningSessions;
    @Nullable
    private ExecutorService executorService;

    public JupyterDebugSessionManager() {
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"newKeySet(...)");
        this.runningSessions = keySetView;
    }

    public final void debugInSessionStarted(@NotNull JupyterDebugSessionPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.runningSessions.add(path);
    }

    public final void debugInSessionFinished(@NotNull JupyterDebugSessionPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.runningSessions.remove(path);
    }

    public final boolean isSessionUnderDebug(@NotNull JupyterDebugSessionPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.runningSessions.contains(path);
    }

    @NotNull
    public final synchronized ExecutorService getExecutorService() {
        if (this.executorService == null) {
            this.executorService = Executors.newCachedThreadPool();
        }
        ExecutorService executorService = this.executorService;
        Intrinsics.checkNotNull((Object)executorService);
        return executorService;
    }

    public void dispose() {
        block0: {
            ExecutorService executorService = this.executorService;
            if (executorService == null) break block0;
            executorService.shutdownNow();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/core/jupyter/debugger/common/JupyterDebugSessionManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/jupyter/core/jupyter/debugger/common/JupyterDebugSessionManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JupyterDebugSessionManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(JupyterDebugSessionManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (JupyterDebugSessionManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

