/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.editor;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.editor.NotebookFileRenameListener;
import com.intellij.jupyter.core.editor.NotebookFileRenamedEvent;
import com.intellij.jupyter.core.executor.JupyterExecutionManager;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.utils.JupyterCoroutineKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterFileExtensionsKt;
import com.intellij.notebooks.jupyter.core.jupyter.JupyterFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0082@\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/jupyter/core/editor/NotebookFileListenerService;", "Lcom/intellij/openapi/Disposable$Default;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "isInitialized", "", "installListenerIfNeeded", "", "createAsyncFileListener", "Lcom/intellij/openapi/vfs/AsyncFileListener;", "handleFileRename", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFilePropertyChangeEvent;", "notebook", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "killExecutor", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.jupyter.core"})
public final class NotebookFileListenerService
implements Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private boolean isInitialized;

    public NotebookFileListenerService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public final void installListenerIfNeeded() {
        if (this.isInitialized) {
            return;
        }
        VirtualFileManager.getInstance().addAsyncFileListener(this.createAsyncFileListener(), (Disposable)this);
        this.isInitialized = true;
    }

    private final AsyncFileListener createAsyncFileListener() {
        return arg_0 -> NotebookFileListenerService.createAsyncFileListener$lambda$0(this, arg_0);
    }

    private final void handleFileRename(VFilePropertyChangeEvent event, BackedNotebookVirtualFile notebook) {
        Object object = event.getNewValue();
        String string = object instanceof String ? (String)object : null;
        if (string == null) {
            return;
        }
        String newName = string;
        Path path = JupyterFileExtensionsKt.getRelativePathFromProjectRoot(notebook.getFile(), this.project);
        String newRelativePath = path != null ? ((Object)path).toString() : null;
        ((NotebookFileRenameListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(NotebookFileRenameListener.Companion.getNOTEBOOK_FILE_RENAMED_TOPIC())).fileRenamed(new NotebookFileRenamedEvent(notebook, newName, newRelativePath));
    }

    private final Object killExecutor(Project project, BackedNotebookVirtualFile notebook, Continuation<? super Unit> $completion) {
        Object object = JupyterExecutionManager.Companion.getInstance(project, notebook).killExecution($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final AsyncFileListener.ChangeApplier createAsyncFileListener$lambda$0(NotebookFileListenerService this$0, List events) {
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        return new AsyncFileListener.ChangeApplier(events, this$0){
            final /* synthetic */ List<? extends VFileEvent> $events;
            final /* synthetic */ NotebookFileListenerService this$0;
            {
                this.$events = $events;
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public void afterVfsChange() {
                void $this$forEach$iv;
                Iterable<Object> iterable = this.$events;
                Intrinsics.checkNotNull(iterable);
                iterable = iterable;
                NotebookFileListenerService notebookFileListenerService = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    BackedNotebookVirtualFile notebookVirtualFile2;
                    VirtualFile eventFile;
                    VFileEvent event = (VFileEvent)element$iv;
                    boolean bl = false;
                    if (event.getFile() == null || !Intrinsics.areEqual((Object)eventFile.getFileType(), (Object)JupyterFileType.INSTANCE) || BackedNotebookVirtualFile.Companion.takeIfBacked(eventFile) == null) continue;
                    VFileEvent vFileEvent = event;
                    if (vFileEvent instanceof VFileDeleteEvent) {
                        JupyterCoroutineKt.launchBackground((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(notebookFileListenerService, notebookVirtualFile2, null){
                            int label;
                            final /* synthetic */ NotebookFileListenerService this$0;
                            final /* synthetic */ BackedNotebookVirtualFile $notebookVirtualFile;
                            {
                                this.this$0 = $receiver;
                                this.$notebookVirtualFile = $notebookVirtualFile;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = NotebookFileListenerService.access$killExecutor(this.this$0, NotebookFileListenerService.access$getProject$p(this.this$0), this.$notebookVirtualFile, (Continuation)this);
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }));
                        continue;
                    }
                    if (!(vFileEvent instanceof VFilePropertyChangeEvent)) continue;
                    NotebookFileListenerService.access$handleFileRename(notebookFileListenerService, (VFilePropertyChangeEvent)event, notebookVirtualFile2);
                }
            }
        };
    }

    public static final /* synthetic */ Object access$killExecutor(NotebookFileListenerService $this, Project project, BackedNotebookVirtualFile notebook, Continuation $completion) {
        return $this.killExecutor(project, notebook, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Project access$getProject$p(NotebookFileListenerService $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$handleFileRename(NotebookFileListenerService $this, VFilePropertyChangeEvent event, BackedNotebookVirtualFile notebook) {
        $this.handleFileRename(event, notebook);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/core/editor/NotebookFileListenerService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/jupyter/core/editor/NotebookFileListenerService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nNotebookFileListenerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookFileListenerService.kt\ncom/intellij/jupyter/core/editor/NotebookFileListenerService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,66:1\n30#2,2:67\n*S KotlinDebug\n*F\n+ 1 NotebookFileListenerService.kt\ncom/intellij/jupyter/core/editor/NotebookFileListenerService$Companion\n*L\n64#1:67,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NotebookFileListenerService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<NotebookFileListenerService> serviceClass$iv = NotebookFileListenerService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (NotebookFileListenerService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

