from typing import Any

from django.contrib.auth.backends import BaseBackend
from django.contrib.auth.models import _AnyUser, _User, _UserModel
from django.db.models.options import Options
from django.http.request import HttpRequest
from django.test.client import Client

from .signals import user_logged_in as user_logged_in
from .signals import user_logged_out as user_logged_out
from .signals import user_login_failed as user_login_failed

SESSION_KEY: str
BACKEND_SESSION_KEY: str
HASH_SESSION_KEY: str
REDIRECT_FIELD_NAME: str

def load_backend(path: str) -> BaseBackend: ...
def get_backends() -> list[BaseBackend]: ...
def authenticate(request: HttpRequest | None = ..., **credentials: Any) -> _User | None: ...
async def aauthenticate(request: HttpRequest | None = ..., **credentials: Any) -> _User | None: ...
def login(request: HttpRequest, user: _User | None, backend: type[BaseBackend] | str | None = ...) -> None: ...
async def alogin(request: HttpRequest, user: _User | None, backend: type[BaseBackend] | str | None = ...) -> None: ...
def logout(request: HttpRequest) -> None: ...
async def alogout(request: HttpRequest) -> None: ...
def get_user_model() -> _UserModel: ...
def get_user(request: HttpRequest | Client) -> _AnyUser: ...
async def aget_user(request: HttpRequest | Client) -> _AnyUser: ...
def get_permission_codename(action: str, opts: Options) -> str: ...
def update_session_auth_hash(request: HttpRequest, user: _User) -> None: ...
async def aupdate_session_auth_hash(request: HttpRequest, user: _User) -> None: ...
