/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.requirements.inspections.tools;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.PyRequirementParser;
import com.jetbrains.python.packaging.common.PythonPackage;
import com.jetbrains.python.packaging.management.PythonPackageManager;
import com.jetbrains.python.requirements.PackageUtilsKt;
import com.jetbrains.python.requirements.RequirementsFile;
import com.jetbrains.python.requirements.RequirementsInspectionVisitor;
import com.jetbrains.python.requirements.inspections.quickfixes.InstallAllRequirementsQuickFix;
import com.jetbrains.python.requirements.inspections.quickfixes.InstallRequirementQuickFix;
import com.jetbrains.python.requirements.inspections.quickfixes.PyGenerateRequirementsFileQuickFix;
import com.jetbrains.python.requirements.psi.Requirement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\tH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/python/requirements/inspections/tools/NotInstalledRequirementInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "isDumbAware", "intellij.python.community.impl"})
public final class NotInstalledRequirementInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return new RequirementsInspectionVisitor(holder, session){
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ LocalInspectionToolSession $session;
            {
                this.$holder = $holder;
                this.$session = $session;
                super($holder, $session);
            }

            /*
             * WARNING - void declaration
             */
            public void visitRequirementsFile(RequirementsFile requirementsFile) {
                void $this$forEach$iv;
                void $this$mapTo$iv$iv;
                Object element$iv$iv$iv;
                void $this$mapNotNullTo$iv$iv;
                Collection collection;
                void $this$mapTo$iv$iv2;
                Intrinsics.checkNotNullParameter((Object)((Object)requirementsFile), (String)"requirementsFile");
                List requirements = CollectionsKt.toList((Iterable)requirementsFile.requirements());
                PsiFile psiFile = this.$session.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
                PsiFile psiFile2 = psiFile;
                Sdk sdk2 = PackageUtilsKt.getPythonSdk(psiFile2);
                if (sdk2 == null) {
                    return;
                }
                Sdk sdk3 = sdk2;
                CharSequence charSequence = psiFile2.getText();
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                    PyGenerateRequirementsFileQuickFix[] pyGenerateRequirementsFileQuickFixArray;
                    Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)psiFile2));
                    if (module2 != null) {
                        Module module3 = module2;
                        boolean bl = false;
                        PyGenerateRequirementsFileQuickFix[] pyGenerateRequirementsFileQuickFixArray2 = new PyGenerateRequirementsFileQuickFix[]{new PyGenerateRequirementsFileQuickFix(module3)};
                        pyGenerateRequirementsFileQuickFixArray = pyGenerateRequirementsFileQuickFixArray2;
                    } else {
                        pyGenerateRequirementsFileQuickFixArray = new PyGenerateRequirementsFileQuickFix[]{};
                    }
                    PyGenerateRequirementsFileQuickFix[] fixes = pyGenerateRequirementsFileQuickFixArray;
                    this.$holder.registerProblem((PsiElement)psiFile2, PyPsiBundle.message("INSP.package.requirements.requirements.file.empty", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])Arrays.copyOf(fixes, fixes.length));
                    return;
                }
                Project project = psiFile2.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                PythonPackageManager packageManager = PythonPackageManager.Companion.forSdk(project, sdk3);
                List<PythonPackage> packages2 = packageManager.listInstalledPackagesSnapshot();
                Iterable $this$map$iv = packages2;
                boolean $i$f$map = false;
                Iterable bl = $this$map$iv;
                Iterable<E> destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    PythonPackage pythonPackage = (PythonPackage)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(new PyPackage(it.getName(), it.getVersion()));
                }
                List pyPackages = (List)destination$iv$iv;
                Iterable $this$mapNotNull$iv = requirements;
                boolean $i$f$mapNotNull = false;
                destination$iv$iv = $this$mapNotNull$iv;
                Iterable<Pair> destination$iv$iv2 = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> bl2 = $this$forEach$iv$iv$iv.iterator();
                while (bl2.hasNext()) {
                    Pair pair;
                    T element$iv$iv = element$iv$iv$iv = bl2.next();
                    boolean bl3 = false;
                    Requirement requirement = (Requirement)element$iv$iv;
                    boolean bl4 = false;
                    if (PyRequirementParser.fromLine(requirement.getText()) == null) {
                        pair = null;
                    } else {
                        PyRequirement pyRequirement;
                        boolean isMatched = pyRequirement.match(pyPackages) != null;
                        pair = isMatched ? null : TuplesKt.to((Object)requirement, (Object)pyRequirement);
                    }
                    if (pair == null) continue;
                    Pair it$iv$iv = pair;
                    boolean bl5 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                List notInstalledRequirementsWithPsi = (List)destination$iv$iv2;
                Iterable $this$map$iv2 = notInstalledRequirementsWithPsi;
                boolean $i$f$map22 = false;
                destination$iv$iv2 = $this$map$iv2;
                Collection destination$iv$iv3 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    element$iv$iv$iv = (Pair)item$iv$iv;
                    collection = destination$iv$iv3;
                    boolean bl6 = false;
                    collection.add((PyRequirement)it.getSecond());
                }
                List unsatisfiedRequirements = (List)destination$iv$iv3;
                Object $i$f$map22 = new InstallAllRequirementsQuickFix(unsatisfiedRequirements);
                InstallAllRequirementsQuickFix it = $i$f$map22;
                boolean bl7 = false;
                InstallAllRequirementsQuickFix installAllRequirementsQuickFix = unsatisfiedRequirements.size() > 1 ? $i$f$map22 : null;
                $i$f$map22 = notInstalledRequirementsWithPsi;
                ProblemsHolder problemsHolder = this.$holder;
                boolean $i$f$forEach2 = false;
                for (T element$iv : $this$forEach$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl8 = false;
                    Requirement psiRequirement = (Requirement)pair.component1();
                    PyRequirement pyRequirement = (PyRequirement)pair.component2();
                    Object[] objectArray = new LocalQuickFix[]{new InstallRequirementQuickFix(pyRequirement), installAllRequirementsQuickFix};
                    List fixes = CollectionsKt.listOfNotNull((Object[])objectArray);
                    objectArray = new Object[]{psiRequirement.getRequirement()};
                    String string = PyBundle.message("INSP.requirements.package.not.installed", objectArray);
                    Collection $this$toTypedArray$iv = fixes;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    objectArray = thisCollection$iv.toArray(new LocalQuickFix[0]);
                    problemsHolder.registerProblem((PsiElement)psiRequirement, string, ProblemHighlightType.WARNING, (LocalQuickFix[])Arrays.copyOf(objectArray, objectArray.length));
                }
            }
        };
    }

    public boolean isDumbAware() {
        return true;
    }
}

