/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.push.PushTarget;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitStandardRemoteBranch;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.push.GitPushSource;
import git4idea.push.GitPushSpecParser;
import git4idea.push.GitPushTargetType;
import git4idea.push.GitSpecialRefRemoteBranch;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.validators.GitRefNameValidator;
import java.text.ParseException;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitPushTarget
implements PushTarget {
    private static final Logger LOG = Logger.getInstance(GitPushTarget.class);
    @NotNull
    private final GitRemoteBranch myRemoteBranch;
    private final boolean myIsNewBranchCreated;
    private final boolean myPushingToSpecialRef;
    @Nullable
    private final GitPushTargetType myTargetType;
    private boolean shouldSetNewUpstream;

    public GitPushTarget(@NotNull GitRemoteBranch remoteBranch, boolean isNewBranchCreated) {
        if (remoteBranch == null) {
            GitPushTarget.$$$reportNull$$$0(0);
        }
        this(remoteBranch, isNewBranchCreated, false, null);
    }

    public GitPushTarget(@NotNull GitRemoteBranch remoteBranch, boolean isNewBranchCreated, @NotNull GitPushTargetType targetType) {
        if (remoteBranch == null) {
            GitPushTarget.$$$reportNull$$$0(1);
        }
        if (targetType == null) {
            GitPushTarget.$$$reportNull$$$0(2);
        }
        this(remoteBranch, isNewBranchCreated, false, targetType);
    }

    public GitPushTarget(@NotNull GitRemoteBranch remoteBranch, boolean isNewBranchCreated, boolean isPushingToSpecialRef, @Nullable GitPushTargetType targetType) {
        if (remoteBranch == null) {
            GitPushTarget.$$$reportNull$$$0(3);
        }
        this.myRemoteBranch = remoteBranch;
        this.myIsNewBranchCreated = isNewBranchCreated;
        this.myPushingToSpecialRef = isPushingToSpecialRef;
        this.myTargetType = targetType;
    }

    @NotNull
    public GitRemoteBranch getBranch() {
        GitRemoteBranch gitRemoteBranch = this.myRemoteBranch;
        if (gitRemoteBranch == null) {
            GitPushTarget.$$$reportNull$$$0(4);
        }
        return gitRemoteBranch;
    }

    public boolean hasSomethingToPush() {
        return this.isNewBranchCreated();
    }

    @NotNull
    public String getPresentation() {
        String string = this.myPushingToSpecialRef ? this.myRemoteBranch.getFullName() : this.myRemoteBranch.getNameForRemoteOperations();
        if (string == null) {
            GitPushTarget.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean isNewBranchCreated() {
        return this.myIsNewBranchCreated;
    }

    public boolean isSpecialRef() {
        return this.myPushingToSpecialRef;
    }

    public void shouldSetNewUpstream(boolean value) {
        this.shouldSetNewUpstream = value;
    }

    public boolean shouldSetUpstream(@NotNull GitPushSource pushSource, @NotNull GitRepository repository2) {
        GitLocalBranch sourceBranch;
        if (pushSource == null) {
            GitPushTarget.$$$reportNull$$$0(6);
        }
        if (repository2 == null) {
            GitPushTarget.$$$reportNull$$$0(7);
        }
        return (sourceBranch = pushSource.getBranch()) != null && pushSource.isBranchRef() && (this.isNewBranchCreated() && !GitPushTarget.branchTrackingInfoIsSet(repository2, sourceBranch) || this.shouldSetNewUpstream);
    }

    @Nullable
    public GitPushTargetType getTargetType() {
        return this.myTargetType;
    }

    @NotNull
    public static GitPushTarget parse(@NotNull GitRepository repository2, @Nullable String remoteName, @NotNull String branchName) throws ParseException {
        if (repository2 == null) {
            GitPushTarget.$$$reportNull$$$0(8);
        }
        if (branchName == null) {
            GitPushTarget.$$$reportNull$$$0(9);
        }
        if (remoteName == null) {
            throw new ParseException("No remotes defined", -1);
        }
        if (!GitRefNameValidator.getInstance().checkInput(branchName)) {
            throw new ParseException("Invalid destination branch name: " + branchName, -1);
        }
        GitRemote remote = GitPushTarget.findRemote(repository2.getRemotes(), remoteName);
        if (remote == null) {
            LOG.error("Remote [" + remoteName + "] is not found among " + String.valueOf(repository2.getRemotes()));
            throw new ParseException("Invalid remote: " + remoteName, -1);
        }
        GitRemoteBranch existingRemoteBranch = GitUtil.findRemoteBranch(repository2, remote, branchName);
        if (existingRemoteBranch != null) {
            return new GitPushTarget(existingRemoteBranch, false, GitPushTargetType.CUSTOM);
        }
        GitStandardRemoteBranch rb = new GitStandardRemoteBranch(remote, branchName);
        return new GitPushTarget((GitRemoteBranch)rb, true, GitPushTargetType.CUSTOM);
    }

    @Nullable
    static GitRemote findRemote(@NotNull Collection<GitRemote> remotes, @NotNull String candidate) {
        if (remotes == null) {
            GitPushTarget.$$$reportNull$$$0(10);
        }
        if (candidate == null) {
            GitPushTarget.$$$reportNull$$$0(11);
        }
        return (GitRemote)ContainerUtil.find(remotes, remote -> remote.getName().equals(candidate));
    }

    @Nullable
    public static GitPushTarget getFromPushSpec(@NotNull GitRepository repository2, @NotNull GitLocalBranch sourceBranch) {
        GitRemote remote;
        if (repository2 == null) {
            GitPushTarget.$$$reportNull$$$0(12);
        }
        if (sourceBranch == null) {
            GitPushTarget.$$$reportNull$$$0(13);
        }
        return (remote = GitPushTarget.getRemoteToPush(repository2, GitBranchUtil.getTrackInfoForBranch(repository2, sourceBranch))) == null ? null : GitPushTarget.getFromPushSpec(repository2, remote, sourceBranch);
    }

    @Nullable
    public static GitPushTarget getFromPushSpec(@NotNull GitRepository repository2, @NotNull GitRemote remote, @NotNull GitLocalBranch sourceBranch) {
        List specs;
        if (repository2 == null) {
            GitPushTarget.$$$reportNull$$$0(14);
        }
        if (remote == null) {
            GitPushTarget.$$$reportNull$$$0(15);
        }
        if (sourceBranch == null) {
            GitPushTarget.$$$reportNull$$$0(16);
        }
        if ((specs = remote.getPushRefSpecs()).isEmpty()) {
            return null;
        }
        String targetRef = GitPushSpecParser.getTargetRef(repository2, sourceBranch, specs);
        if (targetRef == null) {
            return null;
        }
        String remotePrefix = "refs/remotes/" + remote.getName() + "/";
        if (targetRef.startsWith("refs/heads/")) {
            targetRef = targetRef.substring("refs/heads/".length());
            GitRemoteBranch remoteBranch = GitUtil.findOrCreateRemoteBranch(repository2, remote, targetRef);
            boolean existingBranch = repository2.getBranches().getRemoteBranches().contains(remoteBranch);
            return new GitPushTarget(remoteBranch, !existingBranch, GitPushTargetType.PUSH_SPEC);
        }
        if (targetRef.startsWith(remotePrefix)) {
            targetRef = targetRef.substring(remotePrefix.length());
            GitRemoteBranch remoteBranch = GitUtil.findOrCreateRemoteBranch(repository2, remote, targetRef);
            boolean existingBranch = repository2.getBranches().getRemoteBranches().contains(remoteBranch);
            return new GitPushTarget(remoteBranch, !existingBranch, GitPushTargetType.PUSH_SPEC);
        }
        GitSpecialRefRemoteBranch remoteBranch = new GitSpecialRefRemoteBranch(targetRef, remote);
        return new GitPushTarget((GitRemoteBranch)remoteBranch, true, true, GitPushTargetType.PUSH_SPEC);
    }

    @Nullable
    private static GitRemote getRemoteToPush(@NotNull GitRepository repository2, @Nullable GitBranchTrackInfo trackInfo) {
        if (repository2 == null) {
            GitPushTarget.$$$reportNull$$$0(17);
        }
        if (trackInfo != null) {
            return trackInfo.getRemote();
        }
        return GitUtil.getDefaultOrFirstRemote(repository2.getRemotes());
    }

    private static boolean branchTrackingInfoIsSet(@NotNull GitRepository repository2, @NotNull GitLocalBranch source) {
        if (repository2 == null) {
            GitPushTarget.$$$reportNull$$$0(18);
        }
        if (source == null) {
            GitPushTarget.$$$reportNull$$$0(19);
        }
        return ContainerUtil.exists(repository2.getBranchTrackInfos(), info -> info.getLocalBranch().equals((Object)source));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GitPushTarget)) {
            return false;
        }
        GitPushTarget target = (GitPushTarget)o;
        if (this.myIsNewBranchCreated != target.myIsNewBranchCreated) {
            return false;
        }
        if (!this.myRemoteBranch.equals((Object)target.myRemoteBranch)) {
            return false;
        }
        return this.shouldSetNewUpstream == target.shouldSetNewUpstream;
    }

    public int hashCode() {
        int result2 = this.myRemoteBranch.hashCode();
        result2 = 31 * result2 + (this.myIsNewBranchCreated ? 1 : 0);
        result2 = 31 * result2 + (this.shouldSetNewUpstream ? 1 : 0);
        return result2;
    }

    public String toString() {
        return this.myRemoteBranch.getNameForLocalOperations();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteBranch";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/push/GitPushTarget";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pushSource";
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 14: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotes";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceBranch";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remote";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/push/GitPushTarget";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranch";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "shouldSetUpstream";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findRemote";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getFromPushSpec";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteToPush";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "branchTrackingInfoIsSet";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

