function processEndpoint(element, className) {
  let siblings;
  // deprecated paths contain `deprecated` suffix in their class names
  if (className.startsWith("opblock-summary-")) {
    siblings = element.parentNode.children;
  }
  else if (className.startsWith("opblock-summary ")) {
    siblings = element.children;
  }
  if (!siblings) return null;

  let path, method;
  for (siblingIndex = 0; siblingIndex < siblings.length; siblingIndex++) {
    const sibling = siblings.item(siblingIndex);
    if (sibling.className === "opblock-summary-method") {
      method = getName(sibling);
      continue;
    }
    // deprecated paths have `deprecated` suffix
    if (sibling.className.startsWith("opblock-summary-path")) {
      path = getName(sibling)
      continue;
    }
    if (!method || !path) return;
    return "Endpoint#" + sanitize(method) + "#" + sanitize(path);
  }
  return null;
}

function processModel(element, className) {
  if (className.startsWith("model")) {
    let modelName;
    if (className === "model-title__text") {
      modelName = getName(element);
    }
    else if (className === "model model-title") {
      modelName = getName(element);
    }

    if (!modelName) return;
    return "Model#" + sanitize(modelName);
  }
  return null;
}

function getName(element) {
  return element.innerText || element.textContent;
}

function sanitize(string) {
  return string.replace(/[^a-zA-Z0-9\{\}\_\-\/]/g, '')
}