/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.stat.math3;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0007H\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J \u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J(\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J \u0010\u0014\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0004H\u0002J*\u0010\u0018\u001a\u00020\u00192\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0019H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/math3/Percentile;", "", "()V", "MAX_CACHED_LEVELS", "", "MIN_SELECT_SIZE", "evaluate", "", "values", "", "p", "begin", "length", "insertionSort", "", "work", "end", "medianOf3", "partition", "pivot", "select", "pivotsHeap", "", "k", "test", "", "allowEmpty", "plot-base"})
public final class Percentile {
    @NotNull
    public static final Percentile INSTANCE = new Percentile();
    private static final int MIN_SELECT_SIZE = 15;
    private static final int MAX_CACHED_LEVELS = 10;

    private Percentile() {
    }

    public final double evaluate(@NotNull double[] values2, double p) {
        Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
        this.test(values2, 0, 0, false);
        return this.evaluate(values2, 0, values2.length, p);
    }

    private final boolean test(double[] values2, int begin, int length, boolean allowEmpty) {
        if (values2 == null) {
            throw new IllegalStateException("Input array".toString());
        }
        if (begin < 0) {
            throw new IllegalStateException("start postion < 0".toString());
        }
        if (length < 0) {
            throw new IllegalStateException("length < 0".toString());
        }
        if (begin + length > values2.length) {
            throw new IllegalStateException("subarray ends after array end".toString());
        }
        return length != 0 || allowEmpty;
    }

    private final double evaluate(double[] values2, int begin, int length, double p) {
        this.test(values2, begin, length, false);
        if (p > 100.0 || p <= 0.0) {
            throw new IllegalStateException(("out of bounds quantile value: " + p + ", must be in (0, 100]").toString());
        }
        if (length == 0) {
            return Double.NaN;
        }
        if (length == 1) {
            return values2[begin];
        }
        double n = length;
        double pos = p * (n + 1.0) / (double)100;
        double fpos = Math.floor(pos);
        int intPos = (int)fpos;
        double dif = pos - fpos;
        double[] work = new double[length];
        ArraysKt.copyInto((double[])values2, (double[])work, (int)0, (int)begin, (int)length);
        int[] pivotsHeap = new int[1023];
        ArraysKt.fill$default((int[])pivotsHeap, (int)-1, (int)0, (int)0, (int)6, null);
        if (pos < 1.0) {
            return this.select(work, pivotsHeap, 0);
        }
        if (pos >= n) {
            return this.select(work, pivotsHeap, length - 1);
        }
        double lower2 = this.select(work, pivotsHeap, intPos - 1);
        double upper2 = this.select(work, pivotsHeap, intPos);
        return lower2 + dif * (upper2 - lower2);
    }

    private final double select(double[] work, int[] pivotsHeap, int k) {
        int begin = 0;
        int end = work.length;
        int node = 0;
        while (end - begin > 15) {
            int pivot = 0;
            if (node < pivotsHeap.length && pivotsHeap[node] >= 0) {
                pivot = pivotsHeap[node];
            } else {
                pivot = this.partition(work, begin, end, this.medianOf3(work, begin, end));
                if (node < pivotsHeap.length) {
                    pivotsHeap[node] = pivot;
                }
            }
            if (k == pivot) {
                return work[k];
            }
            if (k < pivot) {
                end = pivot;
                node = Math.min(2 * node + 1, pivotsHeap.length);
                continue;
            }
            begin = pivot + 1;
            node = Math.min(2 * node + 2, pivotsHeap.length);
        }
        this.insertionSort(work, begin, end);
        return work[k];
    }

    private final int partition(double[] work, int begin, int end, int pivot) {
        double value = work[pivot];
        work[pivot] = work[begin];
        int i = begin + 1;
        int j = end - 1;
        while (i < j) {
            while (i < j && work[j] >= value) {
                --j;
            }
            while (i < j && work[i] <= value) {
                ++i;
            }
            if (i >= j) continue;
            double tmp = work[i];
            work[i++] = work[j];
            work[j--] = tmp;
        }
        if (i >= end || work[i] > value) {
            --i;
        }
        work[begin] = work[i];
        work[i] = value;
        return i;
    }

    private final int medianOf3(double[] work, int begin, int end) {
        int inclusiveEnd = end - 1;
        int middle = begin + (inclusiveEnd - begin) / 2;
        double wBegin = work[begin];
        double wMiddle = work[middle];
        double wEnd = work[inclusiveEnd];
        return wBegin < wMiddle ? (wMiddle < wEnd ? middle : (wBegin < wEnd ? inclusiveEnd : begin)) : (wBegin < wEnd ? begin : (wMiddle < wEnd ? inclusiveEnd : middle));
    }

    private final void insertionSort(double[] work, int begin, int end) {
        for (int j = begin + 1; j < end; ++j) {
            double saved = work[j];
            for (int i = j - 1; i >= begin && saved < work[i]; --i) {
                work[i + 1] = work[i];
            }
            work[i + 1] = saved;
        }
    }
}

