/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.lang.ecmascript6.refactoring.ES6ModuleMemberInfo;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.presentable.Capitalization;
import com.intellij.lang.javascript.presentable.JSNamedElementPresenter;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.refactoring.JSDefaultRenameProcessor;
import com.intellij.lang.javascript.refactoring.JSRenameExtension;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameMatchingDeclarationInFileProcessor;
import com.intellij.refactoring.rename.RenamePsiFileProcessor;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSRenamePsiFileProcessor
extends RenamePsiFileProcessor
implements RenameMatchingDeclarationInFileProcessor {
    private final boolean myForceHidePreview;

    public JSRenamePsiFileProcessor() {
        this(false);
    }

    public JSRenamePsiFileProcessor(boolean forceHidePreview) {
        this.myForceHidePreview = forceHidePreview;
    }

    public boolean canProcessElement(@NotNull PsiElement element2) {
        if (element2 == null) {
            JSRenamePsiFileProcessor.$$$reportNull$$$0(0);
        }
        if (!(element2 instanceof JSFile)) {
            return false;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement(element2);
        return holder == null || !holder.isECMA4;
    }

    @NotNull
    public RenameDialog createRenameDialog(@NotNull Project project, @NotNull PsiElement element2, PsiElement nameSuggestionContext, Editor editor) {
        if (project == null) {
            JSRenamePsiFileProcessor.$$$reportNull$$$0(1);
        }
        if (element2 == null) {
            JSRenamePsiFileProcessor.$$$reportNull$$$0(2);
        }
        RenameDialog dialog = super.createRenameDialog(project, element2, nameSuggestionContext, editor);
        if (this.myForceHidePreview) {
            dialog.setPreviewResults(false);
        }
        RenameDialog renameDialog = dialog;
        if (renameDialog == null) {
            JSRenamePsiFileProcessor.$$$reportNull$$$0(3);
        }
        return renameDialog;
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element2, @NotNull SearchScope searchScope, boolean searchInCommentsAndStrings) {
        if (element2 == null) {
            JSRenamePsiFileProcessor.$$$reportNull$$$0(4);
        }
        if (searchScope == null) {
            JSRenamePsiFileProcessor.$$$reportNull$$$0(5);
        }
        long currentModificationCount = PsiModificationTracker.getInstance((Project)element2.getProject()).getModificationCount();
        Long setTimestamp = (Long)element2.getUserData(JSDefaultRenameProcessor.FORCE_SEARCH_FOR_FILE_REFERENCES_KEY);
        if (setTimestamp != null && currentModificationCount == setTimestamp) {
            Collection collection = ReferencesSearch.search((PsiElement)element2, (SearchScope)searchScope).findAll();
            if (collection == null) {
                JSRenamePsiFileProcessor.$$$reportNull$$$0(6);
            }
            return collection;
        }
        Collection collection = super.findReferences(element2, searchScope, searchInCommentsAndStrings);
        if (collection == null) {
            JSRenamePsiFileProcessor.$$$reportNull$$$0(7);
        }
        return collection;
    }

    public void prepareRenaming(@NotNull PsiElement element2, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        String newElementName;
        JSFile containingFile;
        JSNamedElement declaration;
        if (element2 == null) {
            JSRenamePsiFileProcessor.$$$reportNull$$$0(8);
        }
        if (newName == null) {
            JSRenamePsiFileProcessor.$$$reportNull$$$0(9);
        }
        if (allRenames == null) {
            JSRenamePsiFileProcessor.$$$reportNull$$$0(10);
        }
        if ((declaration = (JSNamedElement)this.findMatchingDeclaration(containingFile = (JSFile)element2)) != null && RefactoringSettings.getInstance().RENAME_DECLARATION_WHEN_RENAME_FILE && (newElementName = JSNameSuggestionsUtil.fileNameToElementName((PsiNamedElement)declaration, newName)) != null && !StringUtil.equals((CharSequence)newElementName, (CharSequence)declaration.getName())) {
            boolean renameRelated;
            String message = JavaScriptBundle.message("javascript.rename.related.declaration.message", new JSNamedElementPresenter((PsiElement)declaration).describeElementKind());
            String title = JavaScriptBundle.message("javascript.rename.element.with.related.elements.title", new JSNamedElementPresenter(containingFile, Capitalization.UpperCase).describeElementKind());
            boolean bl = renameRelated = !RefactoringSettings.getInstance().ASK_FOR_RENAME_DECLARATION_WHEN_RENAME_FILE || MessageDialogBuilder.yesNo((String)title, (String)message).ask(element2.getProject());
            if (renameRelated) {
                allRenames.put((PsiElement)declaration, newElementName);
                JSRenamePsiFileProcessor.renameRelatedSymbols(allRenames, containingFile, declaration, FileUtil.getNameWithoutExtension((String)newName));
            }
        }
        super.prepareRenaming(element2, newName, allRenames);
    }

    public static void renameRelatedSymbols(@NotNull Map<PsiElement, String> allRenames, @NotNull PsiFile containingFile, @NotNull JSNamedElement declaration, @NotNull String newFileNameWithoutExt) {
        if (allRenames == null) {
            JSRenamePsiFileProcessor.$$$reportNull$$$0(11);
        }
        if (containingFile == null) {
            JSRenamePsiFileProcessor.$$$reportNull$$$0(12);
        }
        if (declaration == null) {
            JSRenamePsiFileProcessor.$$$reportNull$$$0(13);
        }
        if (newFileNameWithoutExt == null) {
            JSRenamePsiFileProcessor.$$$reportNull$$$0(14);
        }
        long count = PsiModificationTracker.getInstance((Project)containingFile.getProject()).getModificationCount();
        containingFile.putUserData(JSDefaultRenameProcessor.FORCE_SEARCH_FOR_FILE_REFERENCES_KEY, (Object)count);
        for (JSRenameExtension extension : (JSRenameExtension[])JSRenameExtension.EP_NAME.getExtensions()) {
            Map<PsiFile, String> files = extension.getAdditionalFilesToRename((PsiElement)declaration, containingFile, newFileNameWithoutExt);
            for (Map.Entry<PsiFile, String> entry : files.entrySet()) {
                entry.getKey().putUserData(JSDefaultRenameProcessor.FORCE_SEARCH_FOR_FILE_REFERENCES_KEY, (Object)count);
                allRenames.put((PsiElement)entry.getKey(), entry.getValue());
            }
        }
    }

    @Nullable
    public PsiElement findMatchingDeclaration(@NotNull PsiFile file) {
        PsiElement[] children;
        if (file == null) {
            JSRenamePsiFileProcessor.$$$reportNull$$$0(15);
        }
        Ref result2 = new Ref();
        for (PsiElement child : children = file.getChildren()) {
            JSQualifiedNamedElement element2 = ES6ModuleMemberInfo.getMember(child);
            if (!(element2 instanceof JSVariable) && !(element2 instanceof JSClass) && !(element2 instanceof JSFunction) || !JSNameSuggestionsUtil.matchesFileNameRelaxed(element2)) continue;
            result2.set((Object)element2);
            return element2;
        }
        return (PsiElement)result2.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/JSRenamePsiFileProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFileNameWithoutExt";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/JSRenamePsiFileProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenameDialog";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createRenameDialog";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findReferences";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "prepareRenaming";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "renameRelatedSymbols";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findMatchingDeclaration";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6, 7 -> new IllegalStateException(string);
        };
    }
}

