/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp.rc;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.lang.javascript.buildTools.gulp.GulpService;
import com.intellij.lang.javascript.buildTools.gulp.codeInsight.GulpfilePsiStructure;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpConfigurationType;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunConfiguration;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunSettings;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GulpRunConfigurationProducer
extends LazyRunConfigurationProducer<GulpRunConfiguration> {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = (ConfigurationFactory)ConfigurationTypeUtil.findConfigurationType(GulpConfigurationType.class);
        if (configurationFactory == null) {
            GulpRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        return configurationFactory;
    }

    protected boolean setupConfigurationFromContext(@NotNull GulpRunConfiguration configuration, @NotNull ConfigurationContext context2, @NotNull Ref<PsiElement> sourceElement) {
        GulpRunSettings runSettings;
        if (configuration == null) {
            GulpRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context2 == null) {
            GulpRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (sourceElement == null) {
            GulpRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if ((runSettings = GulpRunConfigurationProducer.createRunSettingsFromContext(configuration.getRunSettings(), context2, sourceElement)) == null) {
            return false;
        }
        GulpRunConfigurationProducer.setupConfigurationFromSettings(configuration, runSettings);
        return true;
    }

    public static void setupConfigurationFromSettings(@NotNull GulpRunConfiguration configuration, @NotNull GulpRunSettings runSettings) {
        if (configuration == null) {
            GulpRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (runSettings == null) {
            GulpRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        configuration.setRunSettings(runSettings);
        configuration.setName(GulpRunConfigurationProducer.buildName(runSettings.getTasks()));
    }

    public boolean isConfigurationFromContext(@NotNull GulpRunConfiguration configuration, @NotNull ConfigurationContext context2) {
        GulpRunSettings thisRunSettings;
        if (configuration == null) {
            GulpRunConfigurationProducer.$$$reportNull$$$0(6);
        }
        if (context2 == null) {
            GulpRunConfigurationProducer.$$$reportNull$$$0(7);
        }
        if ((thisRunSettings = GulpRunConfigurationProducer.createRunSettingsFromContext(configuration.getRunSettings(), context2, null)) == null) {
            return false;
        }
        return GulpService.getInstance(configuration.getProject()).isConfigurationMatched((RunConfiguration)configuration, thisRunSettings);
    }

    @Nullable
    private static GulpRunSettings createRunSettingsFromContext(@NotNull GulpRunSettings templateRunSettings, @NotNull ConfigurationContext context2, @Nullable Ref<PsiElement> sourceElement) {
        JSFile leastEnclosingElement;
        PsiElement element2;
        if (templateRunSettings == null) {
            GulpRunConfigurationProducer.$$$reportNull$$$0(8);
        }
        if (context2 == null) {
            GulpRunConfigurationProducer.$$$reportNull$$$0(9);
        }
        if ((element2 = GulpRunConfigurationProducer.getElement(context2)) == null || !element2.isValid()) {
            return null;
        }
        JSFile psiGulpfile = GulpRunConfigurationProducer.getGulpfile(element2);
        if (psiGulpfile == null) {
            return null;
        }
        VirtualFile virtualGulpfile = psiGulpfile.getVirtualFile();
        if (virtualGulpfile == null) {
            return null;
        }
        Pair<String, JSCallExpression> taskPair = GulpfilePsiStructure.findEnclosingTask(element2, psiGulpfile);
        GulpRunSettings.Builder builder2 = new GulpRunSettings.Builder(templateRunSettings);
        builder2.setGulpfilePath(FileUtil.toSystemDependentName((String)virtualGulpfile.getPath()));
        if (taskPair != null) {
            builder2.setTasks(Collections.singletonList((String)taskPair.getFirst()));
            leastEnclosingElement = (PsiElement)taskPair.getSecond();
        } else {
            builder2.setTasks(Collections.singletonList("default"));
            leastEnclosingElement = psiGulpfile;
        }
        if (sourceElement != null) {
            sourceElement.set((Object)leastEnclosingElement);
        }
        return builder2.build();
    }

    @Nullable
    private static PsiElement getElement(@NotNull ConfigurationContext context2) {
        Location location;
        if (context2 == null) {
            GulpRunConfigurationProducer.$$$reportNull$$$0(10);
        }
        return (location = context2.getLocation()) != null ? location.getPsiElement() : null;
    }

    @Nullable
    private static JSFile getGulpfile(@NotNull PsiElement element2) {
        VirtualFile file;
        if (element2 == null) {
            GulpRunConfigurationProducer.$$$reportNull$$$0(11);
        }
        JSFile jsFile = element2 instanceof PsiFile ? (JSFile)ObjectUtils.tryCast((Object)element2, JSFile.class) : (JSFile)ObjectUtils.tryCast((Object)element2.getContainingFile(), JSFile.class);
        VirtualFile virtualFile = file = jsFile != null ? jsFile.getVirtualFile() : null;
        if (file != null && GulpService.getInstance(element2.getProject()).isBuildfile(file)) {
            return jsFile;
        }
        return null;
    }

    private static String buildName(@NotNull List<String> tasks) {
        if (tasks == null) {
            GulpRunConfigurationProducer.$$$reportNull$$$0(12);
        }
        if (tasks.isEmpty()) {
            return "default";
        }
        return StringUtil.join(tasks, (String)", ");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfigurationProducer";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runSettings";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateRunSettings";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromSettings";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createRunSettingsFromContext";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getElement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getGulpfile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "buildName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> new IllegalArgumentException(string);
        };
    }
}

