/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.codestyle.rules;

import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.linter.tslint.codestyle.rules.TsLintSimpleRule;
import com.intellij.lang.javascript.linter.tslint.codestyle.rules.TslintJsonOption;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a2\u0006\u0002\u0010\u000eJ \u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0002H\u0014\u00a8\u0006\u0012"}, d2={"Lcom/intellij/lang/javascript/linter/tslint/codestyle/rules/ForceQuotemarkRule;", "Lcom/intellij/lang/javascript/linter/tslint/codestyle/rules/TsLintSimpleRule;", "", "<init>", "()V", "getConfigValue", "option", "Lcom/intellij/lang/javascript/linter/tslint/codestyle/rules/TslintJsonOption;", "(Lcom/intellij/lang/javascript/linter/tslint/codestyle/rules/TslintJsonOption;)Ljava/lang/Boolean;", "getSettingsValue", "languageSettings", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;", "codeStyleSettings", "Lcom/intellij/lang/javascript/formatter/JSCodeStyleSettings;", "(Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;Lcom/intellij/lang/javascript/formatter/JSCodeStyleSettings;)Ljava/lang/Boolean;", "setValue", "", "value", "intellij.tslint"})
public final class ForceQuotemarkRule
extends TsLintSimpleRule<Boolean> {
    public ForceQuotemarkRule() {
        super("quotemark");
    }

    @Override
    @Nullable
    protected Boolean getConfigValue(@NotNull TslintJsonOption option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        List<String> stringValues = option.getStringValues();
        if (stringValues.contains("avoid-escape")) {
            return null;
        }
        if (stringValues.contains("single")) {
            return true;
        }
        if (stringValues.contains("double")) {
            return true;
        }
        return null;
    }

    @Override
    @NotNull
    protected Boolean getSettingsValue(@NotNull CommonCodeStyleSettings languageSettings, @NotNull JSCodeStyleSettings codeStyleSettings) {
        Intrinsics.checkNotNullParameter((Object)languageSettings, (String)"languageSettings");
        Intrinsics.checkNotNullParameter((Object)codeStyleSettings, (String)"codeStyleSettings");
        return codeStyleSettings.FORCE_QUOTE_STYlE;
    }

    @Override
    protected void setValue(@NotNull CommonCodeStyleSettings languageSettings, @NotNull JSCodeStyleSettings codeStyleSettings, boolean value) {
        Intrinsics.checkNotNullParameter((Object)languageSettings, (String)"languageSettings");
        Intrinsics.checkNotNullParameter((Object)codeStyleSettings, (String)"codeStyleSettings");
        codeStyleSettings.FORCE_QUOTE_STYlE = value;
    }
}

