# Arabic (Indigenous)

## Introduction

The Arabic sky culture displays the indigenous star knowledge of the ancient Arabs living in the Arabian Peninsula prior to the Greek astronomy influence in the ninth century.

## Description

The star knowledge of the ancient Arabs had been recorded and preserved in old poetry and in the old works of Arab philologists and lexicographers of the Islamic civilization. Many books were written on the subject of star knowledge and anwāʾ [Arabic الأنواء], the Arabic knowledge of meteorology. The editors of Ibn Qutaybah's *Kitāb al-Anwāʾ* (9th century) listed twenty-four books on this subject written mostly between early eighth and tenth century[#2]. The only completely preserved text is that of Ibn Qutaybah, but later scholars had quoted many of the earlier texts. One of the most significant works that recorded the indigenous Arab star names is the *Book of the stars* written in ~ 964 AD by the prominent astronomer: al-Ṣūfī, where he identified the indigenous Arab star names with the respective Ptolemaic stars of the Greek constellations[#5].

### Constellations

The ancient Arabs gave names to single stars, star couples, an area in the sky, and particular shape of a group of stars. Single stars were named after a human figure or a desert animal, Arcturus is al-Simāk al-Rāmiḥ, meaning: The High one with the spear. Canopus is Suhayl, a proper name of a man. We have also stars named: The Caracal and the Kid (the young goat). If two stars of comparable brightness are close to each other, they are given a common name like: The two Calves, the Two Wolves, The Two doves. Sometimes an area is named after a group of animals. The brighter stars are adult animals, and the faint ones are the young animals like: The Hyenas and their youngsters, The horses and the foals. Particular shapes of stars were given names like the Scorpion, The lion, al-Ǧawzā’ which is a proper name of a woman for Orion stars. Other asterisms are given names according to legends and stories.

## References

 - [#1]: Manuscripts of the Book of Stars
 - [#2]: Ibn Qutaybah, Al-Dinawarī, Abū Muḥammad ʿAbd Allah b. Muslim (died ~ 889), Kitab al-Anwāʾ (Book of meteorolgy), (Arabic print of the original book, Daʾirat al-Maʿarif al-Osmania, Hydarabad, India, 1956), أبو محمد عبد الله بن مسلم ابن قتيبة الدينوري (توفي 276 هـ)، كتاب الأنواء في مواسم العرب، دائرة المعارف العثمانية، حيدر أباد، الهند، 1375 هـ
 - [#3]: Al-Marzūqī, Abū ʿAli Aḥmad b. Muḥammad b. al-Ḥassan (died 1030), Al-Azminah wa al-amkinah (Times and Places), (Arabic print of the original book in 2002, World of Books, Beirut, Lebanon)., الإمام أبو علي أحمد بن محمد بن الحسن المرزوقي (توفي سنة 421 هـ)، الأزمنة والأمكنة، تحقيق د. محمد نايف الدليمي، عالم الكتب، بيروت، لبنان، 1422 هـ.
 - [#4]: Al-Ṯaqafī, ʿAbd Allah b. Ḥussayn b. ʿĀṣim (died ~ 1012), Al-Anwāʾ wa al-azminah (Meteorology and times), (Arabic print of the original book in 1996, Dar al-jeel, Beirut, Lebanon), عبد الله بن حسين بن عاصم الثقفي (توفي 403 هـ)، الأنواء والأزمنة، تحقيق: د. نوري حمودي القيسي، د. محمد نايف الدليمي، دار الجيل، بيروت، لبنان، 1416 هـ.
 - [#5]: [">Book of the stars by al-Ṣūfī (died 986): Critical edition with commentary by Khalid al-Ajaji, digital edition, 2021, كتاب الكواكب لأبي الحسين عبد الرحمن بن عمر الرازي المعروف بالصوفي (291-376)، تحقيق خالد بن عبد الله العجاجي](https://drive.google.com/drive/folders/1s6JXzftwjMQ5rgZoGE3718EtBLBZtjzr?usp=sharing)
 - [#6]: Al-Farāhīdī, abū ʿAbd al-Raḥmān al-Ḫalīl b. Aḥmad (died ~ 786 AD), Kitab al-ʿayn, a lexicon titled: The book of ʿayn (Arabic letter العين), (Arabic print of the original book, 1980 – 1985), أبو عبد الرحمن الخليل بن أحمد الفراهيدي (توفي 170 ه)، كتاب العين، 1400 – 1405 هـ.
 - [#7]: Ibn Durayd, abu Bakr Muḥammad b. al-Ḥassan b. Durayd al-Azdi (died ~ 933 AD), Ǧamharat al-luġah lexicon (The Collection of the Language), Dar al-Ilm lil-malayeen, Beirut, Lebanon, (Arabic print of the original book, 1987), ابن دريد، أبو بكر محمد بن الحسن بن دريد الأزدي (توفي 321 ه)، جمهرة اللغة، دار العلم للملايين، بيروت، لبنان، 1987م.
 - [#8]: Instructions Nautiques et Routiers Arabes et Portugais , I , Ibn Majid, Gabriel Ferrand, 1921 -1923.
 - [#9]: Instructions Nautiques et Routiers Arabes et Portugais , II, Sulayman al-Mahri et Ibn Majid, Gabriel Ferrand, 1925.
 - [#10]: Al-Ǧawhirī, abu Naṣr Ismaʿīl b. Ḥammād al-Ǧawhirī al-Farabī (died ~ 1003 AD), Al-Siḥāḥ lexicon, Dar al-Ilm lil-malayeen, Beirut, Lebanon, (Arabic print of the original book, 1987),  أبو نصر إسماعيل بن حماد الجوهري الفارابي (ت ٣٩٣هـ)، الصحاح تاج اللغة وصحاح العربية، دار العلم للملايين - بيروت، 1407 هـ.
 - [#11]: Al-Qalqašandī, abu al-Abbas Aḥmad (died ~ 1418 AD), Ṣubḥ al-Aša, Dar al-kutub al-Misriyah, Cairo, Egypt, (Arabic print of the original book, 1922)., القلقشندي، أبو العباس أحمد، صبح الأعشى، دار الكتب المصرية، 1340 هـ.

## Authors

Khalid al-Ajaji: turath.alfalak@gmail.com

## License

CC BY-NC-ND 4.0
