/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.tests;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.operations.completion.LSContentAssistProcessor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.wildwebdeveloper.Activator;
import org.eclipse.wildwebdeveloper.tests.AllCleanRule;
import org.eclipse.wildwebdeveloper.tests.MarkdownTest;
import org.eclipse.wildwebdeveloper.tests.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={AllCleanRule.class})
class TestMarkdown {
    TestMarkdown() {
    }

    @Test
    void diagnosticsCoverTypicalMarkdownIssues() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getClass().getName() + System.nanoTime());
        project.create(null);
        project.open(null);
        Collection<MarkdownTest> markerTests = Collections.synchronizedCollection(new ArrayList());
        markerTests.add(new MarkdownTest("Reference link to [an undefined reference][missing-ref]", "No link definition found: 'missing-ref'", 1));
        markerTests.add(new MarkdownTest("Relative file link: [data](./nonexistent-folder/data.csv)", "File does not exist at path: .*data\\.csv", 1));
        markerTests.add(new MarkdownTest("Broken image: ![logo](../assets/logo.png)", "File does not exist at path: .*logo\\.png", 1));
        markerTests.add(new MarkdownTest("Link to missing header in this file: [Jump to Setup](#setup)", "No header found: 'setup'", 1));
        markerTests.add(new MarkdownTest("Link to missing header in another file: [See Guide](./GUIDE.md#installing)", "Header does not exist in file: installing", 1));
        markerTests.add(new MarkdownTest("Undefined footnote here [^missing-footnote]", "No link definition found: '\\^missing-footnote'", 1));
        markerTests.add(new MarkdownTest("This is a paragraph with an [undefined link][undefined-link].", "No link definition found: 'undefined-link'", 1));
        markerTests.add(new MarkdownTest("[unused-link]: https://unused-link.com", "Link definition is unused", 1));
        markerTests.add(new MarkdownTest("This is a paragraph with a [duplicate link][duplicate-link].\n[duplicate-link]: https://duplicate-link.com\n[duplicate-link]: https://duplicate-link.com\n", "Link definition for 'duplicate-link' already exists", 2));
        IFile referencedFile = project.getFile("GUIDE.md");
        referencedFile.create("".getBytes(), true, false, null);
        IFile file = project.getFile("broken.md");
        file.create(markerTests.stream().map(MarkdownTest::markdown).collect(Collectors.joining("\n")).getBytes(StandardCharsets.UTF_8), true, false, null);
        TextEditor editor = (TextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        Display display = editor.getSite().getShell().getDisplay();
        IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        AtomicReference markdownLS = new AtomicReference();
        DisplayHelper.waitForCondition((Display)display, (long)10000L, () -> {
            markdownLS.set(LanguageServiceAccessor.getStartedWrappers((IDocument)doc, null, (boolean)false).stream().filter(w -> "org.eclipse.wildwebdeveloper.markdown".equals(w.serverDefinition.id)).findFirst().orElse(null));
            return markdownLS.get() != null && ((LanguageServerWrapper)markdownLS.get()).isActive() && ((LanguageServerWrapper)markdownLS.get()).isConnectedTo(LSPEclipseUtils.toUri((IDocument)doc));
        });
        DisplayHelper.waitForCondition((Display)PlatformUI.getWorkbench().getDisplay(), (long)15000L, () -> {
            IMarker[] markers;
            block5: {
                markers = file.findMarkers("org.eclipse.wildwebdeveloper.markdown.problem", true, 0);
                if (markers.length != 0) break block5;
                return false;
            }
            try {
                IMarker[] iMarkerArray = markers;
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker m = iMarkerArray[n2];
                    Object msgObj = m.getAttribute("message");
                    if (msgObj instanceof String) {
                        String msg = (String)msgObj;
                        markerTests.removeIf(t -> t.severity() == m.getAttribute("severity", -1) && msg.matches(t.messagePattern()));
                    }
                    ++n2;
                }
                return markerTests.isEmpty();
            }
            catch (CoreException e) {
                return false;
            }
        });
        Assertions.assertTrue((boolean)markerTests.isEmpty(), (String)("The following markers were not found: " + String.valueOf(markerTests)));
    }

    @Test
    void workspaceHeaderCompletionsRespectExcludeGlobs() throws Exception {
        IFolder genFolder;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getClass().getName() + ".hdr" + System.nanoTime());
        project.create(null);
        project.open(null);
        Activator.getDefault().getPreferenceStore().setValue("markdown.suggest.paths.excludeGlobs", "docs/generated/**");
        IFolder docsFolder = project.getFolder("docs");
        if (!docsFolder.exists()) {
            docsFolder.create(true, true, null);
        }
        if (!(genFolder = docsFolder.getFolder("generated")).exists()) {
            genFolder.create(true, true, null);
        }
        IFile excluded = project.getFile("docs/generated/excluded.md");
        excluded.create("# Excluded Only\n".getBytes(StandardCharsets.UTF_8), true, false, null);
        IFile included = project.getFile("docs/included.md");
        included.create("# Included Only\n".getBytes(StandardCharsets.UTF_8), true, false, null);
        IFile index = project.getFile("index.md");
        index.create("[](##)\n".getBytes(StandardCharsets.UTF_8), true, false, null);
        TextEditor editor = (TextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)index);
        Display display = editor.getSite().getShell().getDisplay();
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        AtomicReference markdownLS = new AtomicReference();
        Assertions.assertTrue((boolean)DisplayHelper.waitForCondition((Display)display, (long)10000L, () -> {
            markdownLS.set(LanguageServiceAccessor.getStartedWrappers((IDocument)document, null, (boolean)false).stream().filter(w -> "org.eclipse.wildwebdeveloper.markdown".equals(w.serverDefinition.id)).findFirst().orElse(null));
            return markdownLS.get() != null && ((LanguageServerWrapper)markdownLS.get()).isActive() && ((LanguageServerWrapper)markdownLS.get()).isConnectedTo(LSPEclipseUtils.toUri((IDocument)document));
        }), (String)"Markdown LS did not start");
        int offset = document.get().indexOf("##") + 2;
        LSContentAssistProcessor cap = new LSContentAssistProcessor();
        Assertions.assertTrue((boolean)DisplayHelper.waitForCondition((Display)display, (long)15000L, () -> {
            ICompletionProposal[] proposals = cap.computeCompletionProposals((ITextViewer)Utils.getViewer((AbstractTextEditor)editor), offset);
            if (proposals == null || proposals.length == 0) {
                return false;
            }
            boolean hasIncluded = Arrays.stream(proposals).anyMatch(p -> "#included-only".equals(p.getDisplayString()));
            boolean hasExcluded = Arrays.stream(proposals).anyMatch(p -> "#excluded-only".equals(p.getDisplayString()));
            return hasIncluded && !hasExcluded;
        }), (String)"Workspace header completions did not respect exclude globs");
    }
}

