"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.r = void 0;
exports.isEmptyOrWhitespace = isEmptyOrWhitespace;
exports.fuzzyContains = fuzzyContains;
function isEmptyOrWhitespace(str) {
    return /^\s*$/.test(str);
}
exports.r = String.raw;
/**
 * Checks if the characters of the provided query string are included in the
 * target string. The characters do not have to be contiguous within the string.
 */
function fuzzyContains(target, query) {
    if (target.length < query.length) {
        return false; // impossible for query to be contained in target
    }
    const queryLen = query.length;
    const targetLower = target.toLowerCase();
    let index = 0;
    let lastIndexOf = -1;
    while (index < queryLen) {
        const indexOf = targetLower.indexOf(query[index], lastIndexOf + 1);
        if (indexOf < 0) {
            return false;
        }
        lastIndexOf = indexOf;
        index++;
    }
    return true;
}
//# sourceMappingURL=string.js.map