/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.trace;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.trace.Metadata;
import org.junit.Assert;
import org.junit.Test;

public class MetadataPrevalidationTest {
    private static final String GOOD_TSDL = "/* CTF 1.8 */\ntrace {\n major = 1 ;\n minor = 8 ;\n byte_order = le ; \n};";
    private static final String GOOD_JSON = "\u001e{\n  \"type\": \"preamble\",\n  \"version\": 2\n }";
    private static final String INVALID_JSON = "{\n  \"type\": \"preamble\",\n  \"version\": 3\n }";

    @Test
    public void testTraceNull() throws CTFException {
        Assert.assertFalse((boolean)Metadata.preValidate(null));
    }

    @Test
    public void testTraceFileDoesNotExist() throws CTFException {
        Assert.assertFalse((boolean)Metadata.preValidate((String)"abcdefghijklmnopqrstuvwxyz"));
    }

    @Test
    public void testTraceFile() throws CTFException, IOException {
        File f = File.createTempFile("test", ".log");
        Throwable throwable = null;
        Object var3_4 = null;
        try (PrintWriter pw = new PrintWriter(f);){
            pw.println("2 hello world");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertFalse((boolean)Metadata.preValidate((String)f.getAbsolutePath()));
    }

    @Test
    public void testTraceDirectoryWithNoFiles() throws IOException, CTFException {
        Path dir = Files.createTempDirectory("trace", new FileAttribute[0]);
        Assert.assertFalse((boolean)Metadata.preValidate((String)dir.toAbsolutePath().toString()));
    }

    @Test
    public void testTraceDirectoryWithNoMetadataButFiles() throws CTFException, IOException {
        Path dir = Files.createTempDirectory("trace", new FileAttribute[0]);
        Path f = Files.createFile(dir.resolve("metadata"), new FileAttribute[0]);
        Throwable throwable = null;
        Object var4_5 = null;
        try (PrintWriter pw = new PrintWriter(f.toFile());){
            pw.println("2 hello world");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertFalse((boolean)Metadata.preValidate((String)dir.toAbsolutePath().toString()));
    }

    @Test
    public void testTraceDirectoryWithLittleEndianMetadata() throws CTFException, IOException {
        Path dir = Files.createTempDirectory("trace", new FileAttribute[0]);
        Path f = Files.createFile(dir.resolve("metadata"), new FileAttribute[0]);
        Files.write(f, MetadataPrevalidationTest.packetize(GOOD_TSDL, ByteOrder.BIG_ENDIAN), new OpenOption[0]);
        Assert.assertTrue((boolean)Metadata.preValidate((String)dir.toAbsolutePath().toString()));
    }

    @Test
    public void testTraceDirectoryWithBigEndianMetadata() throws CTFException, IOException {
        Path dir = Files.createTempDirectory("trace", new FileAttribute[0]);
        Path f = Files.createFile(dir.resolve("metadata"), new FileAttribute[0]);
        Files.write(f, MetadataPrevalidationTest.packetize(GOOD_TSDL, ByteOrder.BIG_ENDIAN), new OpenOption[0]);
        Assert.assertTrue((boolean)Metadata.preValidate((String)dir.toAbsolutePath().toString()));
    }

    @Test
    public void testTraceDirectoryWithTextMetadata() throws IOException, CTFException {
        Path dir = Files.createTempDirectory("trace", new FileAttribute[0]);
        Path f = Files.createFile(dir.resolve("metadata"), new FileAttribute[0]);
        Throwable throwable = null;
        Object var4_5 = null;
        try (PrintWriter pw = new PrintWriter(f.toFile());){
            pw.println(GOOD_TSDL);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertTrue((boolean)Metadata.preValidate((String)dir.toAbsolutePath().toString()));
    }

    @Test
    public void testTraceDirectoryWithJsonMetadata() throws IOException, CTFException {
        Path dir = Files.createTempDirectory("trace", new FileAttribute[0]);
        Path f = Files.createFile(dir.resolve("metadata"), new FileAttribute[0]);
        Throwable throwable = null;
        Object var4_5 = null;
        try (PrintWriter pw = new PrintWriter(f.toFile());){
            pw.println(GOOD_JSON);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertTrue((boolean)Metadata.preValidate((String)dir.toAbsolutePath().toString()));
    }

    @Test
    public void testTraceDirectoryWithAllowedStartStringMetadata1() throws IOException, CTFException {
        Path dir = Files.createTempDirectory("trace", new FileAttribute[0]);
        Path f = Files.createFile(dir.resolve("metadata"), new FileAttribute[0]);
        Throwable throwable = null;
        Object var4_5 = null;
        try (PrintWriter pw = new PrintWriter(f.toFile());){
            pw.println("trace { major =1 ; minor = 8 ; byte_order = le;};");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertTrue((boolean)Metadata.preValidate((String)dir.toAbsolutePath().toString()));
    }

    @Test
    public void testTraceDirectoryWithAllowedStartStringMetadata2() throws IOException, CTFException {
        Path dir = Files.createTempDirectory("trace", new FileAttribute[0]);
        Path f = Files.createFile(dir.resolve("metadata"), new FileAttribute[0]);
        Throwable throwable = null;
        Object var4_5 = null;
        try (PrintWriter pw = new PrintWriter(f.toFile());){
            pw.println("typealias integer { size = 8; align = 8; signed = false; } := uint8_t;");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertTrue((boolean)Metadata.preValidate((String)dir.toAbsolutePath().toString()));
    }

    @Test
    public void testTraceDirectoryWithAllowedStartStringMetadata3() throws IOException, CTFException {
        Path dir = Files.createTempDirectory("trace", new FileAttribute[0]);
        Path f = Files.createFile(dir.resolve("metadata"), new FileAttribute[0]);
        Throwable throwable = null;
        Object var4_5 = null;
        try (PrintWriter pw = new PrintWriter(f.toFile());){
            pw.println("env {\n    hostname = \"localhost.localdomain\";\n    domain = \"kernel\";\n    sysname = \"Linux\";\n    kernel_release = \"4.18.16-rt9\";\n    kernel_version = \"#1 SMP PREEMPT RT Thu Jun 23 10:43:50 EDT 2022\";\n    tracer_name = \"lttng-modules\";\n    tracer_major = 2;\n    tracer_minor = 14;\n    tracer_patchlevel = 0;\n    trace_buffering_scheme = \"global\";\n    trace_name = \"default-k-20250724-093844\";\n    trace_creation_datetime = \"20250724T093844-0400\";\n    product_uuid = \"03000200-0400-0500-0006-000700080009\";\n};");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertTrue((boolean)Metadata.preValidate((String)dir.toAbsolutePath().toString()));
    }

    @Test
    public void testTraceDirectoryWithInvalidMetadata() throws IOException, CTFException {
        Path dir = Files.createTempDirectory("trace", new FileAttribute[0]);
        Path f = Files.createFile(dir.resolve("metadata"), new FileAttribute[0]);
        Throwable throwable = null;
        Object var4_5 = null;
        try (PrintWriter pw = new PrintWriter(f.toFile());){
            pw.println("clock {\n    name = \"monotonic\";\n    uuid = \"e7602765-7075-4f0b-814a-87c901e6837f\";\n    description = \"Monotonic Clock\";\n    freq = 1000000000; /* Frequency, in Hz */\n    /* clock value offset from Epoch is: offset * (1/freq) */\n    offset = 1753351888197109407;\n};");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertFalse((boolean)Metadata.preValidate((String)dir.toAbsolutePath().toString()));
    }

    @Test
    public void testTraceDirectoryWithInvalidJson() throws IOException, CTFException {
        Path dir = Files.createTempDirectory("trace", new FileAttribute[0]);
        Path f = Files.createFile(dir.resolve("metadata"), new FileAttribute[0]);
        Throwable throwable = null;
        Object var4_5 = null;
        try (PrintWriter pw = new PrintWriter(f.toFile());){
            pw.println(INVALID_JSON);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertFalse((boolean)Metadata.preValidate((String)dir.toAbsolutePath().toString()));
    }

    @Test
    public void testTraceDirectoryWithEmptyMetadata() throws IOException, CTFException {
        Path dir = Files.createTempDirectory("trace", new FileAttribute[0]);
        Files.createFile(dir.resolve("metadata"), new FileAttribute[0]);
        Assert.assertFalse((boolean)Metadata.preValidate((String)dir.toAbsolutePath().toString()));
    }

    @Test
    public void testTraceDirectoryWith1ByteMetadata() throws IOException, CTFException {
        Path dir = Files.createTempDirectory("trace", new FileAttribute[0]);
        Path f = Files.createFile(dir.resolve("metadata"), new FileAttribute[0]);
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileWriter pw = new FileWriter(f.toFile());){
            pw.append('x');
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertFalse((boolean)Metadata.preValidate((String)dir.toAbsolutePath().toString()));
    }

    private static byte[] packetize(String body, ByteOrder bo) {
        byte[] retVal = new byte[40 + body.length()];
        ByteBuffer bb = ByteBuffer.wrap(retVal);
        bb.order(bo);
        MetadataPrevalidationTest.generateMetadataPacketHeader(bb, body);
        return retVal;
    }

    private static void generateMetadataPacketHeader(ByteBuffer headerByteBuffer, String body) {
        headerByteBuffer.putInt(1976638807);
        UUID randomUUID = UUID.randomUUID();
        headerByteBuffer.putLong(randomUUID.getMostSignificantBits());
        headerByteBuffer.putLong(randomUUID.getLeastSignificantBits());
        headerByteBuffer.putInt(0);
        headerByteBuffer.putInt(body.length());
        headerByteBuffer.putInt(body.length());
        headerByteBuffer.put((byte)0);
        headerByteBuffer.put((byte)0);
        headerByteBuffer.putInt(0);
        headerByteBuffer.put((byte)1);
        headerByteBuffer.put((byte)8);
        headerByteBuffer.put(body.getBytes());
    }
}

