/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.help.internal.webapp.parser.ParseElement;
import org.eclipse.help.internal.webapp.utils.JSonHelper;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ResultParser
extends DefaultHandler {
    protected String id;
    protected String label;
    protected ArrayList<ParseElement> items = new ArrayList();

    public ResultParser(String label) {
        this(label, "id");
    }

    public ResultParser(String label, String id) {
        this.label = label;
        this.id = id;
    }

    public void parse(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        SAXParser parser = XmlProcessorFactory.createSAXParserWithErrorOnDOCTYPE();
        parser.parse(in, (DefaultHandler)this);
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setIdentifier(String id) {
        this.id = id;
    }

    public ArrayList<ParseElement> getItems() {
        return this.items;
    }

    public String toString() {
        return this.items.toString();
    }

    public String toJSON() {
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        buf.append("\n   ");
        buf.append(JSonHelper.getQuotes("identifier"));
        buf.append(":");
        buf.append(JSonHelper.getQuotes(this.id));
        buf.append(",");
        buf.append("\n   ");
        buf.append(JSonHelper.getQuotes("label"));
        buf.append(":");
        buf.append(JSonHelper.getQuotes(this.label));
        buf.append(",");
        buf.append("\n   ");
        buf.append(JSonHelper.getQuotes("items"));
        buf.append(":");
        buf.append("[");
        int i = 0;
        while (i < this.items.size()) {
            if (i > 0) {
                buf.append(",");
            }
            ParseElement element = this.items.get(i);
            buf.append(element.toJSON(1));
            ++i;
        }
        if (!this.items.isEmpty()) {
            buf.append("\n   ");
        }
        buf.append("]");
        buf.append("\n");
        buf.append("}");
        return buf.toString();
    }
}

