/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl;

import java.nio.ByteOrder;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.ctf.core.event.metadata.DeclarationScope;
import org.eclipse.tracecompass.ctf.core.event.types.EnumDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.parser.CTFParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.AbstractScopedCommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.CTFAntlrMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.CTFJsonMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.JsonStructureFieldMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TsdlUtils;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TypeDeclarationParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.enumeration.EnumParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.floatingpoint.FloatDeclarationParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.integer.IntegerDeclarationParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.string.StringDeclarationParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.struct.StructParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.variant.VariantParser;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.types.composite.EventHeaderCompactDeclaration;
import org.eclipse.tracecompass.internal.ctf.core.event.types.composite.EventHeaderLargeDeclaration;

public final class TypeSpecifierListParser
extends AbstractScopedCommonTreeParser {
    public static final TypeSpecifierListParser INSTANCE = new TypeSpecifierListParser();

    private TypeSpecifierListParser() {
    }

    @Override
    public IDeclaration parse(ICTFMetadataNode typeSpecifierList, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        if (!(param instanceof Param)) {
            throw new IllegalArgumentException("Param must be a " + Param.class.getCanonicalName());
        }
        DeclarationScope scope = ((Param)param).fDeclarationScope;
        List<@NonNull ICTFMetadataNode> pointerList = ((Param)param).fListNode;
        CTFTrace trace = ((Param)param).fTrace;
        ICTFMetadataNode identifier = ((Param)param).fIdentifier;
        IDeclaration declaration = null;
        ICTFMetadataNode firstChild = null;
        String type = null;
        if (typeSpecifierList instanceof CTFAntlrMetadataNode) {
            firstChild = typeSpecifierList.getChild(0);
            type = firstChild.getType();
        } else if (typeSpecifierList instanceof CTFJsonMetadataNode) {
            firstChild = typeSpecifierList;
        }
        if (CTFParser.tokenNames[100].equals(type)) {
            declaration = FloatDeclarationParser.INSTANCE.parse(firstChild, new FloatDeclarationParser.Param(trace));
        } else if (CTFParser.tokenNames[101].equals(type)) {
            declaration = IntegerDeclarationParser.INSTANCE.parse(firstChild, new IntegerDeclarationParser.Param(trace));
        } else if (CTFParser.tokenNames[105].equals(type)) {
            declaration = StringDeclarationParser.INSTANCE.parse(firstChild, null);
        } else if (CTFParser.tokenNames[106].equals(type) || firstChild instanceof JsonStructureFieldMetadataNode) {
            IDeclaration idEnumDecl;
            declaration = StructParser.INSTANCE.parse(firstChild, new StructParser.Param(trace, identifier, scope));
            StructDeclaration structDeclaration = (StructDeclaration)declaration;
            if (structDeclaration.hasField("id") && (idEnumDecl = structDeclaration.getField("id")) instanceof EnumDeclaration) {
                EnumDeclaration enumDeclaration = (EnumDeclaration)idEnumDecl;
                ByteOrder bo = enumDeclaration.getContainerType().getByteOrder();
                if (EventHeaderCompactDeclaration.getEventHeader(bo).isCompactEventHeader(structDeclaration)) {
                    declaration = EventHeaderCompactDeclaration.getEventHeader(bo);
                } else if (EventHeaderLargeDeclaration.getEventHeader(bo).isLargeEventHeader(structDeclaration)) {
                    declaration = EventHeaderLargeDeclaration.getEventHeader(bo);
                }
            }
        } else if (CTFParser.tokenNames[123].equals(type)) {
            declaration = VariantParser.INSTANCE.parse(firstChild, new VariantParser.Param(trace, scope));
        } else if (CTFParser.tokenNames[91].equals(type)) {
            declaration = EnumParser.INSTANCE.parse(firstChild, new EnumParser.Param(trace, scope));
        } else if (CTFParser.tokenNames[38].equals(type) || CTFParser.tokenNames[32].equals(type) || CTFParser.tokenNames[43].equals(type) || CTFParser.tokenNames[46].equals(type) || CTFParser.tokenNames[62].equals(type) || CTFParser.tokenNames[64].equals(type) || CTFParser.tokenNames[78].equals(type) || CTFParser.tokenNames[11].equals(type) || CTFParser.tokenNames[25].equals(type) || CTFParser.tokenNames[80].equals(type) || CTFParser.tokenNames[8].equals(type) || CTFParser.tokenNames[19].equals(type) || CTFParser.tokenNames[39].equals(type)) {
            declaration = TypeDeclarationParser.INSTANCE.parse(typeSpecifierList, new TypeDeclarationParser.Param(pointerList, scope));
        } else {
            throw TsdlUtils.childTypeError(firstChild);
        }
        return declaration;
    }

    @NonNullByDefault
    public static final class Param
    implements ICommonTreeParser.ICommonTreeParserParameter {
        private final DeclarationScope fDeclarationScope;
        private final @Nullable List<ICTFMetadataNode> fListNode;
        private final CTFTrace fTrace;
        private final @Nullable ICTFMetadataNode fIdentifier;

        public Param(CTFTrace trace, @Nullable List<ICTFMetadataNode> listNode, @Nullable ICTFMetadataNode identifier, DeclarationScope scope) {
            this.fTrace = trace;
            this.fListNode = listNode;
            this.fIdentifier = identifier;
            this.fDeclarationScope = scope;
        }
    }
}

