/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.kernelmemoryusage;

import com.google.common.collect.ImmutableSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.os.linux.core.kernelmemoryusage.KernelMemoryStateProvider;
import org.eclipse.tracecompass.analysis.os.linux.core.tid.TidAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.DefaultEventLayout;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelTrace;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class KernelMemoryAnalysisModule
extends TmfStateSystemAnalysisModule {
    public static final @NonNull String ID = "org.eclipse.tracecompass.analysis.os.linux.core.kernelmemory";
    public static final @NonNull String THREAD_LOWEST_MEMORY_VALUE = "lowestMemory";

    protected Iterable<IAnalysisModule> getDependentAnalyses() {
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            throw new IllegalStateException("Trace should not be null");
        }
        IAnalysisModule module = TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, TidAnalysisModule.class, (String)"org.eclipse.tracecompass.analysis.os.linux.kernel.tid");
        if (module == null) {
            throw new IllegalStateException("Module should not be null");
        }
        return ImmutableSet.of((Object)module);
    }

    protected @NonNull ITmfStateProvider createStateProvider() {
        ITmfTrace trace = (ITmfTrace)NonNullUtils.checkNotNull((Object)this.getTrace());
        IKernelAnalysisEventLayout layout = trace instanceof IKernelTrace ? ((IKernelTrace)trace).getKernelEventLayout() : DefaultEventLayout.getInstance();
        return new KernelMemoryStateProvider(trace, layout);
    }
}

