/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.comment;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.internal.comment.CommentingStrategy;

public class LineCommentingStrategy
extends CommentingStrategy {
    private String fPrefix;

    public LineCommentingStrategy(String prefix) {
        this.fPrefix = prefix;
    }

    @Override
    public void apply(IStructuredDocument document, int offset, int length) throws BadLocationException {
        document.replace(offset, 0, String.valueOf(this.fPrefix) + " ");
    }

    @Override
    public void remove(IStructuredDocument document, int offset, int length, boolean removeEnclosing) throws BadLocationException {
        String content = document.get(offset, length);
        int innerOffset = content.indexOf(this.fPrefix);
        if (innerOffset > 0) {
            offset += innerOffset;
        }
        LineCommentingStrategy.uncomment((IDocument)document, offset, this.fPrefix, -1, null);
    }

    @Override
    public boolean alreadyCommenting(IStructuredDocument document, IRegion region) throws BadLocationException {
        String regionContent = document.get(region.getOffset(), region.getLength()).trim();
        return regionContent.startsWith(this.fPrefix);
    }

    @Override
    public Object clone() {
        return new LineCommentingStrategy(this.fPrefix);
    }
}

