/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text2;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.search.internal.ui.text.FileSearchQuery;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.TextSearchQueryProvider;
import org.eclipse.ui.IWorkingSet;

public class DefaultTextSearchQueryProvider
extends TextSearchQueryProvider {
    @Override
    public ISearchQuery createQuery(TextSearchQueryProvider.TextSearchInput input) {
        FileTextSearchScope scope = input.getScope();
        String text = input.getSearchText();
        boolean regEx = input.isRegExSearch();
        boolean caseSensitive = input.isCaseSensitiveSearch();
        boolean wholeWord = input.isWholeWordSearch();
        boolean searchInBinaries = input.searchInBinaries();
        Assert.isLegal((!wholeWord || !regEx ? 1 : 0) != 0);
        return new FileSearchQuery(text, regEx, caseSensitive, wholeWord, searchInBinaries, scope);
    }

    @Override
    public ISearchQuery createQuery(String searchForString) {
        FileTextSearchScope scope = FileTextSearchScope.newWorkspaceScope(this.getPreviousFileNamePatterns(), false);
        return new FileSearchQuery(searchForString, false, true, scope);
    }

    @Override
    public ISearchQuery createQuery(String selectedText, IResource[] resources) {
        FileTextSearchScope scope = FileTextSearchScope.newSearchScope(resources, this.getPreviousFileNamePatterns(), false);
        return new FileSearchQuery(selectedText, false, true, scope);
    }

    @Override
    public ISearchQuery createQuery(String selectedText, IWorkingSet[] ws) {
        FileTextSearchScope scope = FileTextSearchScope.newSearchScope(ws, this.getPreviousFileNamePatterns(), false);
        return new FileSearchQuery(selectedText, false, true, scope);
    }

    private String[] getPreviousFileNamePatterns() {
        return new String[]{"*"};
    }
}

