/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.control.core.tests.model.impl;

import org.eclipse.tracecompass.internal.lttng2.control.core.model.ITraceInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.TraceInfo;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TraceInfoTest {
    private ITraceInfo fTraceInfo1 = null;
    private ITraceInfo fTraceInfo2 = null;

    @Before
    public void setUp() {
        this.fTraceInfo1 = new TraceInfo("event1");
        this.fTraceInfo2 = new TraceInfo("event2");
    }

    @Test
    public void testTraceInfo() {
        TraceInfo fixture = new TraceInfo("event");
        Assert.assertNotNull((Object)fixture);
        Assert.assertEquals((Object)"event", (Object)fixture.getName());
    }

    @Test
    public void testTraceInfo2() {
        try {
            String name = null;
            new TraceInfo(name);
            Assert.fail((String)"null name in custructor");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testTraceInfoCopy() {
        TraceInfo info = new TraceInfo((TraceInfo)this.fTraceInfo1);
        Assert.assertEquals((Object)this.fTraceInfo1.getName(), (Object)info.getName());
    }

    @Test
    public void testTraceCopy2() {
        try {
            TraceInfo info = null;
            new TraceInfo(info);
            Assert.fail((String)"null copy");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSetName() {
        TraceInfo fixture = new TraceInfo("event");
        fixture.setName("newName");
        Assert.assertEquals((Object)"newName", (Object)fixture.getName());
    }

    @Test
    public void testToString_1() {
        String result = this.fTraceInfo1.toString();
        Assert.assertEquals((Object)"[TraceInfo(Name=event1)]", (Object)result);
    }

    @Test
    public void testEqualsReflexivity() {
        Assert.assertTrue((String)"equals", (boolean)this.fTraceInfo1.equals(this.fTraceInfo1));
        Assert.assertTrue((String)"equals", (boolean)this.fTraceInfo2.equals(this.fTraceInfo2));
        Assert.assertTrue((String)"equals", (!this.fTraceInfo1.equals(this.fTraceInfo2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.fTraceInfo2.equals(this.fTraceInfo1) ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsSymmetry() {
        TraceInfo info1 = new TraceInfo((TraceInfo)this.fTraceInfo1);
        TraceInfo info2 = new TraceInfo((TraceInfo)this.fTraceInfo2);
        Assert.assertTrue((String)"equals", (boolean)info1.equals((Object)this.fTraceInfo1));
        Assert.assertTrue((String)"equals", (boolean)this.fTraceInfo1.equals(info1));
        Assert.assertTrue((String)"equals", (boolean)info2.equals((Object)this.fTraceInfo2));
        Assert.assertTrue((String)"equals", (boolean)this.fTraceInfo2.equals(info2));
    }

    @Test
    public void testEqualsTransivity() {
        TraceInfo info1 = new TraceInfo((TraceInfo)this.fTraceInfo1);
        TraceInfo info2 = new TraceInfo((TraceInfo)this.fTraceInfo1);
        TraceInfo info3 = new TraceInfo((TraceInfo)this.fTraceInfo1);
        Assert.assertTrue((String)"equals", (boolean)info1.equals((Object)info2));
        Assert.assertTrue((String)"equals", (boolean)info2.equals((Object)info3));
        Assert.assertTrue((String)"equals", (boolean)info1.equals((Object)info3));
    }

    @Test
    public void testEqualsNull() {
        Assert.assertTrue((String)"equals", (!this.fTraceInfo1.equals(null) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.fTraceInfo2.equals(null) ? 1 : 0) != 0);
    }

    @Test
    public void testHashCode() {
        TraceInfo info1 = new TraceInfo((TraceInfo)this.fTraceInfo1);
        TraceInfo info2 = new TraceInfo((TraceInfo)this.fTraceInfo2);
        Assert.assertTrue((String)"hashCode", (this.fTraceInfo1.hashCode() == info1.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fTraceInfo2.hashCode() == info2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fTraceInfo1.hashCode() != info2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fTraceInfo2.hashCode() != info1.hashCode() ? 1 : 0) != 0);
    }
}

