/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.cdtvariables;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.cdtvariables.CdtVariable;
import org.eclipse.cdt.core.cdtvariables.ICdtVariable;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.core.cdtvariables.CoreMacroSupplierBase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class CdtMacroSupplier
extends CoreMacroSupplierBase {
    public static final String VAR_CONFIG_NAME = "ConfigName";
    public static final String VAR_CONFIG_DESCRIPTION = "ConfigDescription";
    public static final String VAR_PROJ_NAME = "ProjName";
    public static final String VAR_PROJ_DIR_PATH = "ProjDirPath";
    public static final String VAR_WORKSPACE_DIR_PATH = "WorkspaceDirPath";
    public static final String VAR_DIRECTORY_DELIMITER = "DirectoryDelimiter";
    public static final String VAR_PATH_DELIMITER = "PathDelimiter";
    public static final String VAR_ECLIPSE_VERSION = "EclipseVersion";
    public static final String VAR_CDT_VERSION = "CDTVersion";
    public static final String VAR_HOST_OS_NAME = "HostOsName";
    public static final String VAR_HOST_ARCH_NAME = "HostArchName";
    public static final String VAR_OS_TYPE = "OsType";
    public static final String VAR_ARCH_TYPE = "ArchType";
    private static CdtMacroSupplier fInstance;
    private static final String[] fConfigurationMacros;
    private static final String[] fWorkspaceMacros;
    private static final String[] fCDTEclipseMacros;

    static {
        fConfigurationMacros = new String[]{VAR_CONFIG_NAME, VAR_CONFIG_DESCRIPTION, VAR_PROJ_NAME, VAR_PROJ_DIR_PATH};
        fWorkspaceMacros = new String[]{VAR_WORKSPACE_DIR_PATH, VAR_DIRECTORY_DELIMITER, VAR_PATH_DELIMITER};
        fCDTEclipseMacros = new String[]{VAR_ECLIPSE_VERSION, VAR_CDT_VERSION, VAR_HOST_OS_NAME, VAR_HOST_ARCH_NAME, VAR_OS_TYPE, VAR_ARCH_TYPE};
    }

    public String[] getMacroNames(int contextType) {
        return this.getMacroNames(contextType, true);
    }

    private String[] getMacroNames(int contextType, boolean clone) {
        String[] names = null;
        switch (contextType) {
            case 3: {
                names = fConfigurationMacros;
                break;
            }
            case 5: {
                names = fWorkspaceMacros;
                break;
            }
            case 6: {
                names = fCDTEclipseMacros;
                break;
            }
        }
        if (names != null) {
            return clone ? (String[])names.clone() : names;
        }
        return null;
    }

    private CdtMacroSupplier() {
    }

    public static CdtMacroSupplier getInstance() {
        if (fInstance == null) {
            fInstance = new CdtMacroSupplier();
        }
        return fInstance;
    }

    @Override
    public ICdtVariable getMacro(String macroName, int contextType, Object contextData) {
        ICdtVariable macro = null;
        switch (contextType) {
            case 3: {
                if (!(contextData instanceof ICConfigurationDescription)) break;
                macro = this.getMacro(macroName, (ICConfigurationDescription)contextData);
                break;
            }
            case 5: {
                if (contextData != null && !(contextData instanceof IWorkspace)) break;
                macro = this.getMacro(macroName, (IWorkspace)contextData);
                break;
            }
            case 6: {
                if (contextData != null) break;
                macro = this.getMacro(macroName);
                break;
            }
        }
        return macro;
    }

    private IProject getProject(ICConfigurationDescription cfgDes) {
        ICProjectDescription des = cfgDes.getProjectDescription();
        return des != null ? des.getProject() : null;
    }

    public ICdtVariable getMacro(String macroName, ICConfigurationDescription cfg) {
        IProject project;
        CdtVariable macro = null;
        if (VAR_CONFIG_NAME.equals(macroName)) {
            macro = new CdtVariable(macroName, 1, cfg.getName());
        } else if (VAR_CONFIG_DESCRIPTION.equals(macroName)) {
            macro = new CdtVariable(macroName, 1, cfg.getDescription());
        } else if (VAR_PROJ_NAME.equals(macroName)) {
            IProject project2 = this.getProject(cfg);
            if (project2 != null) {
                macro = new CdtVariable(macroName, 1, project2.getName());
            }
        } else if (VAR_PROJ_DIR_PATH.equals(macroName) && (project = this.getProject(cfg)) != null && project.getLocation() != null) {
            macro = new CdtVariable(macroName, 1, project.getLocation().toString());
        }
        return macro;
    }

    public ICdtVariable getMacro(String macroName, IWorkspace wsp) {
        if (wsp == null) {
            wsp = ResourcesPlugin.getWorkspace();
        }
        CdtVariable macro = null;
        if (VAR_WORKSPACE_DIR_PATH.equals(macroName)) {
            macro = new CdtVariable(macroName, 5, wsp.getRoot().getLocation().toOSString());
        } else if (VAR_DIRECTORY_DELIMITER.equals(macroName)) {
            macro = this.isWin32() ? new CdtVariable(macroName, 1, "\\") : new CdtVariable(macroName, 1, "/");
        } else if (VAR_PATH_DELIMITER.equals(macroName)) {
            macro = this.isWin32() ? new CdtVariable(macroName, 1, ";") : new CdtVariable(macroName, 1, ":");
        }
        return macro;
    }

    private boolean isWin32() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.startsWith("windows ");
    }

    public ICdtVariable getMacro(String macroName) {
        CdtVariable macro = null;
        if (VAR_ECLIPSE_VERSION.equals(macroName)) {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.platform");
            String version = bundle != null ? (String)bundle.getHeaders().get("Bundle-Version") : null;
            macro = new CdtVariable(macroName, 1, version);
        } else if (VAR_CDT_VERSION.equals(macroName)) {
            String version = (String)CCorePlugin.getDefault().getBundle().getHeaders().get("Bundle-Version");
            macro = new CdtVariable(macroName, 1, version);
        } else if (VAR_HOST_OS_NAME.equals(macroName)) {
            String os = System.getProperty("os.name");
            macro = new CdtVariable(macroName, 1, os);
        } else if (VAR_HOST_ARCH_NAME.equals(macroName)) {
            String arch = System.getProperty("os.arch");
            macro = new CdtVariable(macroName, 1, arch);
        } else if (VAR_OS_TYPE.equals(macroName)) {
            String os = Platform.getOS();
            macro = new CdtVariable(macroName, 1, os);
        } else if (VAR_ARCH_TYPE.equals(macroName)) {
            String arch = Platform.getOSArch();
            macro = new CdtVariable(macroName, 1, arch);
        }
        return macro;
    }

    @Override
    public ICdtVariable[] getMacros(int contextType, Object contextData) {
        String[] names = this.getMacroNames(contextType, false);
        if (names != null) {
            ICdtVariable[] macros = new ICdtVariable[names.length];
            int num = 0;
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                ICdtVariable macro = this.getMacro(name, contextType, contextData);
                if (macro != null) {
                    macros[num++] = macro;
                }
                ++n2;
            }
            if (macros.length != num) {
                ICdtVariable[] tmp = new ICdtVariable[num];
                if (num > 0) {
                    System.arraycopy(macros, 0, tmp, 0, num);
                }
                macros = tmp;
            }
            return macros;
        }
        return null;
    }
}

