/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.completion.provider;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ease.tools.ResourceTools;

public class LocationResolver {
    private final String fLocation;
    private final Object fParent;
    private Object fResolvedFolder;
    private boolean fProcessed = false;
    private String fFilterPart = "";

    public static final boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().startsWith("windows");
    }

    public LocationResolver(String location, Object parent) {
        this.fLocation = location;
        this.fParent = parent;
    }

    public String getFilterPart() {
        this.process();
        return this.fFilterPart;
    }

    public Object getParentFolder() {
        this.process();
        return this.fResolvedFolder;
    }

    public Collection<? extends Object> getChildren() {
        this.process();
        try {
            if (this.fResolvedFolder instanceof IContainer) {
                return Arrays.asList(((IContainer)this.fResolvedFolder).members());
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        if (this.fResolvedFolder instanceof File) {
            if (LocationResolver.isWindows() && ResourceTools.VIRTUAL_WINDOWS_ROOT.equals(this.fResolvedFolder)) {
                return Arrays.asList(File.listRoots());
            }
            File[] files = ((File)this.fResolvedFolder).listFiles();
            if (files != null) {
                return Arrays.asList(files);
            }
        }
        return Collections.emptySet();
    }

    public String getParentString() {
        this.process();
        if (ResourceTools.isAbsolute((String)this.fLocation)) {
            return ResourceTools.toAbsoluteLocation((Object)this.getParentFolder(), null);
        }
        String parentString = this.fLocation.substring(0, this.fLocation.length() - this.getFilterPart().length());
        while (parentString.endsWith("/")) {
            parentString = parentString.substring(0, parentString.length() - 1);
        }
        return parentString;
    }

    private void process() {
        if (!this.fProcessed) {
            this.fResolvedFolder = ResourceTools.resolve((Object)this.fLocation, (Object)this.fParent);
            if (!ResourceTools.isFolder((Object)this.fResolvedFolder) && !ResourceTools.VIRTUAL_WINDOWS_ROOT.equals(this.fResolvedFolder)) {
                this.fFilterPart = LocationResolver.isWindows() && this.fLocation.contains("\\") ? this.fLocation.substring(this.fLocation.lastIndexOf(92) + 1) : (this.fLocation.contains("/") ? this.fLocation.substring(this.fLocation.lastIndexOf(47) + 1) : this.fLocation);
                String locationStr = this.fLocation.substring(0, this.fLocation.length() - this.fFilterPart.length());
                this.fResolvedFolder = ResourceTools.resolve((Object)locationStr, (Object)this.fParent);
            }
            if (!ResourceTools.isFolder((Object)this.fResolvedFolder) && !ResourceTools.VIRTUAL_WINDOWS_ROOT.equals(this.fResolvedFolder)) {
                if (this.fParent instanceof IFile) {
                    this.fResolvedFolder = ((IFile)this.fParent).getParent();
                } else if (this.fParent instanceof File && ((File)this.fParent).isDirectory()) {
                    this.fResolvedFolder = ((File)this.fParent).getParentFile();
                }
            }
            this.fProcessed = true;
        }
    }
}

