/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.crypto.ec;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.python.bouncycastle.crypto.CipherParameters;
import org.python.bouncycastle.crypto.ec.ECPair;
import org.python.bouncycastle.crypto.ec.ECPairTransform;
import org.python.bouncycastle.crypto.ec.ECUtil;
import org.python.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.python.bouncycastle.crypto.params.ParametersWithRandom;
import org.python.bouncycastle.math.ec.ECPoint;

public class ECNewPublicKeyTransform
implements ECPairTransform {
    private ECPublicKeyParameters key;
    private SecureRandom random;

    public void init(CipherParameters cipherParameters) {
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            if (!(parametersWithRandom.getParameters() instanceof ECPublicKeyParameters)) {
                throw new IllegalArgumentException("ECPublicKeyParameters are required for new public key transform.");
            }
            this.key = (ECPublicKeyParameters)parametersWithRandom.getParameters();
            this.random = parametersWithRandom.getRandom();
        } else {
            if (!(cipherParameters instanceof ECPublicKeyParameters)) {
                throw new IllegalArgumentException("ECPublicKeyParameters are required for new public key transform.");
            }
            this.key = (ECPublicKeyParameters)cipherParameters;
            this.random = new SecureRandom();
        }
    }

    public ECPair transform(ECPair eCPair) {
        if (this.key == null) {
            throw new IllegalStateException("ECNewPublicKeyTransform not initialised");
        }
        BigInteger bigInteger = this.key.getParameters().getN();
        BigInteger bigInteger2 = ECUtil.generateK(bigInteger, this.random);
        ECPoint eCPoint = this.key.getParameters().getG();
        ECPoint eCPoint2 = eCPoint.multiply(bigInteger2);
        ECPoint eCPoint3 = this.key.getQ().multiply(bigInteger2).add(eCPair.getY());
        return new ECPair(eCPoint2.normalize(), eCPoint3.normalize());
    }
}

