/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ease.AbstractScriptEngine;
import org.eclipse.ease.ExitException;
import org.eclipse.ease.ICodeFactory;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Logger;
import org.eclipse.ease.Script;
import org.eclipse.ease.ScriptEngineCancellationException;
import org.eclipse.ease.modules.AbstractScriptModule;
import org.eclipse.ease.modules.IEnvironment;
import org.eclipse.ease.modules.IModuleCallbackProvider;
import org.eclipse.ease.modules.IModuleListener;
import org.eclipse.ease.modules.IScriptModule;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.ease.modules.ModuleHelper;
import org.eclipse.ease.modules.ModuleTracker;
import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.ease.service.ScriptService;
import org.eclipse.ease.tools.ListenerList;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class EnvironmentModule
extends AbstractScriptModule
implements IEnvironment {
    public static final String MODULE_NAME = "/System/Environment";
    public static final String INCLUDE_METHOD = "include";
    public static final String LOAD_JAR_METHOD = "loadJar";
    public static final String LOAD_MODULE_METHOD = "loadModule";
    private static final Pattern VALID_TOPICS_PATTERN = Pattern.compile("[\\w ]+(?:\\(\\))?");
    private final ModuleTracker fModuleTracker = new ModuleTracker();
    private final ListenerList<IModuleListener> fModuleListeners = new ListenerList();
    private final Map<String, Method> fRegisteredMethods = new HashMap<String, Method>();
    private final ListenerList<IModuleCallbackProvider> fModuleCallbacks = new ListenerList();
    private final Collection<String> fPrintedErrors = new HashSet<String>();

    public static void bootstrap() throws ExecutionException {
        ModuleDefinition definition = ModuleHelper.resolveModuleName(MODULE_NAME);
        IEnvironment instance = (IEnvironment)definition.createModuleInstance();
        instance.initialize(AbstractScriptEngine.getCurrentScriptEngine(), instance);
        instance.wrap(instance, false);
    }

    public static final String getWrappedVariableName(Object toBeWrapped) {
        return ("__EASE_MOD_" + toBeWrapped.getClass().getName()).replace('.', '_');
    }

    public EnvironmentModule() {
        ModuleDefinition moduleDefinition = ModuleHelper.resolveModuleName(MODULE_NAME);
        ModuleTracker.ModuleState state = this.fModuleTracker.addModule(moduleDefinition);
        state.setInstance(this);
    }

    public Object getModuleInstance(ModuleDefinition definition) {
        ModuleTracker.ModuleState moduleState = this.fModuleTracker.getOrCreateModuleState(definition);
        if (!moduleState.isLoaded()) {
            if (definition.isDeprecated()) {
                this.printError("Module \"" + definition.getName() + "\" is deprecated. Consider updating your code.", false);
            }
            this.createModuleDependencies(definition);
            Object instance = definition.createModuleInstance();
            moduleState.setInstance(instance);
            if (instance == null) {
                throw new RuntimeException("Could not create module instance, see workspace log for more details");
            }
            if (instance instanceof IScriptModule) {
                ((IScriptModule)instance).initialize(this.getScriptEngine(), this);
            }
            this.fireModuleEvent(instance, 1);
        }
        return moduleState.getInstance();
    }

    private void createModuleDependencies(ModuleDefinition parentModuleDefinition) {
        for (ModuleDefinition.ModuleDependency dependency : parentModuleDefinition.getDependencies()) {
            ModuleDefinition dependencyDefinition = dependency.getDefinition();
            if (dependencyDefinition == null) {
                throw new RuntimeException("Could not resolve module dependency \"" + dependency.getId() + "\"");
            }
            this.createModuleDependencies(dependencyDefinition);
            this.getModuleInstance(dependencyDefinition);
        }
    }

    @Override
    @WrapToScript
    public final Object loadModule(String moduleIdentifier, @ScriptParameter(defaultValue="false") boolean useCustomNamespace) throws ExecutionException {
        ModuleDefinition definition = ModuleHelper.resolveModuleName(moduleIdentifier);
        if (definition == null) {
            throw new IllegalArgumentException("Could not find module \"" + moduleIdentifier + "\"");
        }
        ModuleTracker.ModuleState moduleState = this.fModuleTracker.getOrCreateModuleState(definition);
        this.getModuleInstance(definition);
        if (!useCustomNamespace) {
            this.wrapModuleDependencies(definition);
        }
        return this.wrap(moduleState.getInstance(), useCustomNamespace);
    }

    private void wrapModuleDependencies(ModuleDefinition parentModuleDefinition) throws ExecutionException {
        for (ModuleDefinition.ModuleDependency dependency : parentModuleDefinition.getDependencies()) {
            ModuleDefinition dependencyDefinition = dependency.getDefinition();
            this.wrapModuleDependencies(dependencyDefinition);
            ModuleTracker.ModuleState dependencyState = this.fModuleTracker.getOrCreateModuleState(dependencyDefinition);
            if (dependencyState.isWrapped()) continue;
            this.wrap(dependencyState.getInstance(), false);
        }
    }

    @Override
    @WrapToScript
    public final Object getModule(String name) {
        ModuleDefinition definition = ModuleHelper.resolveModuleName(name);
        if (definition == null) {
            return null;
        }
        ModuleTracker.ModuleState moduleState = this.fModuleTracker.getModuleState(definition);
        return moduleState != null ? moduleState.getInstance() : null;
    }

    @Override
    public <T, U extends Class<T>> T getModule(U clazz) {
        return this.fModuleTracker.getAvailableModules().stream().filter(s -> s.getInstance() != null).filter(s -> clazz.isAssignableFrom(s.getInstance().getClass())).map(s -> s.getInstance()).findFirst().orElse(null);
    }

    @Override
    public List<Object> getModules() {
        return this.fModuleTracker.getAvailableModules().stream().filter(state -> state.isLoaded()).map(state -> state.getInstance()).collect(Collectors.toList());
    }

    @Override
    public ModuleDefinition getModuleDefinition(Object moduleInstance) {
        Optional<ModuleDefinition> definition = this.fModuleTracker.getAvailableModules().stream().filter(state -> Objects.equals(moduleInstance, state.getInstance())).map(s -> s.getModuleDefinition()).findFirst();
        return definition.orElseThrow(() -> new IllegalArgumentException("No module loaded for provided instance"));
    }

    @Override
    @WrapToScript(supportedLanguages="!Python")
    public final void print(@ScriptParameter(defaultValue="") Object text, @ScriptParameter(defaultValue="true") boolean lineFeed) {
        if (lineFeed) {
            this.getScriptEngine().getOutputStream().println(text);
        } else {
            this.getScriptEngine().getOutputStream().print(text);
        }
    }

    @WrapToScript
    public final void printError(@ScriptParameter(defaultValue="") Object text, @ScriptParameter(defaultValue="false") boolean printOnce) {
        String printedText = String.valueOf(text);
        if (!printOnce || !this.fPrintedErrors.contains(printedText)) {
            this.getScriptEngine().getErrorStream().println(printedText);
            this.fPrintedErrors.add(printedText);
        }
    }

    @Override
    public void addModuleListener(IModuleListener listener) {
        this.fModuleListeners.add(listener);
    }

    @Override
    public void removeModuleListener(IModuleListener listener) {
        this.fModuleListeners.remove(listener);
    }

    @WrapToScript
    public String readInput(@ScriptParameter(defaultValue="true") boolean blocking) throws IOException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        InputStream inputStream = this.getScriptEngine().getInputStream();
        while (inputStream.available() > 0 || blocking) {
            int in = inputStream.read();
            if (in == -1 || '\n' == (char)in) break;
            if ('\r' == (char)in) continue;
            data.write(in);
        }
        return data.toString();
    }

    protected void fireModuleEvent(Object module, int type) {
        Object[] objectArray = this.fModuleListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IModuleListener)listener).notifyModule(module, type);
            ++n2;
        }
    }

    @Override
    @WrapToScript
    public Object wrap(Object toBeWrapped, @ScriptParameter(defaultValue="false") boolean useCustomNamespace) throws ExecutionException {
        String identifier = this.getCodeFactory().getSaveVariableName(EnvironmentModule.getWrappedVariableName(toBeWrapped));
        boolean reloaded = this.getScriptEngine().hasVariable(identifier);
        this.getScriptEngine().setVariable(identifier, toBeWrapped);
        Logger.trace("org.eclipse.ease", ICodeFactory.TRACE_MODULE_WRAPPER, "wrapping object: " + toBeWrapped.toString());
        Object result = this.createWrappers(toBeWrapped, identifier, useCustomNamespace);
        this.fModuleTracker.getAvailableModules().stream().filter(m -> Objects.equals(toBeWrapped, m.getInstance())).forEach(m -> m.setWrapped());
        if (reloaded) {
            this.fireModuleEvent(toBeWrapped, 2);
        }
        return result;
    }

    private Object createWrappers(Object instance, String identifier, boolean useCustomNamespace) throws ExecutionException {
        String wrapperCode = instance instanceof IEnvironment ? this.getCodeFactory().createWrapper((IEnvironment)instance, instance, identifier, useCustomNamespace, this.getScriptEngine()) : this.getCodeFactory().createWrapper(this, instance, identifier, useCustomNamespace, this.getScriptEngine());
        Object injectionResult = this.getScriptEngine().inject(new Script("Wrapper(" + instance.getClass().getSimpleName() + ")", wrapperCode), false);
        return useCustomNamespace ? injectionResult : instance;
    }

    @WrapToScript
    public final Object execute(Object data) throws ExecutionException {
        return this.getScriptEngine().inject(data, false);
    }

    @WrapToScript
    public final void exit(@ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object value) throws ExitException {
        throw new ExitException(value);
    }

    @WrapToScript
    public final Object include(Object resource) throws ExecutionException {
        Object file = ResourceTools.resolve(resource, this.getScriptEngine().getExecutedFile());
        if (file != null) {
            return this.getScriptEngine().inject(file, false);
        }
        throw new IllegalArgumentException("Cannot locate '" + resource + "'");
    }

    @Override
    @WrapToScript
    public IScriptEngine getScriptEngine() {
        return super.getScriptEngine();
    }

    private ICodeFactory getCodeFactory() {
        return ScriptService.getCodeFactory(this.getScriptEngine());
    }

    @WrapToScript
    public boolean loadJar(Object location) throws MalformedURLException {
        if (!(location instanceof URL)) {
            Object file = ResourceTools.resolve(location, this.getScriptEngine().getExecutedFile());
            if (file instanceof IFile) {
                file = ((IFile)file).getLocation().toFile();
            }
            location = file instanceof File ? ((File)file).toURI().toURL() : new URL(location.toString());
        }
        if (location instanceof URL) {
            this.getScriptEngine().registerJar((URL)location);
            return true;
        }
        return false;
    }

    @WrapToScript(supportedLanguages="!Python")
    public void help(@ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String topic) {
        if (topic != null && !VALID_TOPICS_PATTERN.matcher(topic).matches()) {
            this.printError("Invalid help topic to look for: \"" + topic + "\"", false);
            return;
        }
        if (PlatformUI.isWorkbenchRunning()) {
            if (topic != null) {
                for (Object module : this.getModules()) {
                    ModuleDefinition definition = ModuleDefinition.forInstance(module);
                    if (definition == null) continue;
                    for (Method method : definition.getMethods()) {
                        if (!this.matchesMethod(method, topic)) continue;
                        String link = definition.getHelpLocation(method.getName());
                        Display.getDefault().asyncExec(() -> PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(link));
                        return;
                    }
                    for (Field field : definition.getFields()) {
                        if (!this.matchesField(field, topic)) continue;
                        String link = definition.getHelpLocation(field.getName());
                        Display.getDefault().asyncExec(() -> PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(link));
                        return;
                    }
                }
                Display.getDefault().asyncExec(() -> PlatformUI.getWorkbench().getHelpSystem().search(topic));
            } else {
                Display.getDefault().asyncExec(() -> PlatformUI.getWorkbench().getHelpSystem().displayHelp());
            }
        }
    }

    private boolean matchesField(Field field, String name) {
        if (name.equalsIgnoreCase(field.getName())) {
            return true;
        }
        WrapToScript wrapAnnotation = field.getAnnotation(WrapToScript.class);
        if (wrapAnnotation != null) {
            String[] stringArray = wrapAnnotation.alias().split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String alias = stringArray[n2];
                if (name.equalsIgnoreCase(alias.trim())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean matchesMethod(Method method, String name) {
        if (name.equalsIgnoreCase(method.getName())) {
            return true;
        }
        WrapToScript wrapAnnotation = method.getAnnotation(WrapToScript.class);
        if (wrapAnnotation != null) {
            String[] stringArray = wrapAnnotation.alias().split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String alias = stringArray[n2];
                if (name.equalsIgnoreCase(alias.trim())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    public void addModuleCallback(IModuleCallbackProvider callbackProvider) {
        this.fModuleCallbacks.add(callbackProvider);
    }

    public boolean hasMethodCallback(String methodToken) {
        IProgressMonitor monitor = this.getScriptEngine().getMonitor();
        if (monitor != null && monitor.isCanceled()) {
            throw new ScriptEngineCancellationException();
        }
        Method method = this.fRegisteredMethods.get(methodToken);
        return this.fModuleCallbacks.stream().anyMatch(p -> p.hasPreExecutionCallback(method) || p.hasPostExecutionCallback(method));
    }

    public void preMethodCallback(String methodToken, Object ... parameters) {
        Method method = this.fRegisteredMethods.get(methodToken);
        if (method != null) {
            for (IModuleCallbackProvider callbackProvider : this.fModuleCallbacks) {
                if (!callbackProvider.hasPreExecutionCallback(method)) continue;
                callbackProvider.preExecutionCallback(method, parameters);
            }
        }
    }

    public void postMethodCallback(String methodToken, Object result) {
        Method method = this.fRegisteredMethods.get(methodToken);
        if (method != null) {
            for (IModuleCallbackProvider callbackProvider : this.fModuleCallbacks) {
                if (!callbackProvider.hasPostExecutionCallback(method)) continue;
                callbackProvider.postExecutionCallback(method, result);
            }
        }
    }

    @Override
    public String registerMethod(Method method) {
        String key = Integer.toString(method.toString().hashCode());
        this.fRegisteredMethods.put(key, method);
        return key;
    }
}

