/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.memory;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.provisional.tmf.ui.viewers.xychart.BaseXYPresentationProvider;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class MemoryPresentationProvider
extends BaseXYPresentationProvider {
    private static final int DEFAULT_SERIES_WIDTH = 1;
    private static final int THICK_SERIES = 2;
    private Set<Long> fTotalSeries = new TreeSet<Long>();
    private static Map<ITmfTrace, MemoryPresentationProvider> INSTANCES = new HashMap<ITmfTrace, MemoryPresentationProvider>();

    public static MemoryPresentationProvider getForTrace(ITmfTrace trace) {
        return INSTANCES.computeIfAbsent(trace, t -> new MemoryPresentationProvider());
    }

    public void addTotalSeries(long id) {
        this.fTotalSeries.add(id);
    }

    public @NonNull OutputElementStyle getSeriesStyle(@NonNull Long seriesId) {
        if (this.fTotalSeries.contains(seriesId)) {
            return this.getSeriesStyle(seriesId, "line", 2);
        }
        return this.getSeriesStyle(seriesId, "line", 1);
    }
}

