/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.core.search;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.core.search.ISearchOptions;
import org.eclipse.wst.common.core.search.SearchRequestor;
import org.eclipse.wst.common.core.search.document.SearchDocument;
import org.eclipse.wst.common.core.search.document.SearchDocumentSet;
import org.eclipse.wst.common.core.search.pattern.SearchPattern;
import org.eclipse.wst.common.core.search.scope.SearchScope;

public abstract class SearchParticipant
implements ISearchOptions {
    protected static final boolean debugPerf = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.common.core/perf"));
    protected String id;

    protected SearchParticipant() {
    }

    public abstract boolean isApplicable(SearchPattern var1, Map var2);

    public void beginSearching(SearchPattern pattern, Map searchOptions) {
    }

    public void doneSearching(SearchPattern pattern, Map searchOptions) {
    }

    public String getDescription() {
        return "Search participant";
    }

    public abstract SearchDocument createSearchDocument(String var1);

    public abstract void locateMatches(SearchDocumentSet var1, SearchPattern var2, SearchScope var3, SearchRequestor var4, Map var5, IProgressMonitor var6) throws CoreException;

    public abstract void populateSearchDocument(SearchDocument var1, SearchPattern var2);

    public SearchScope selectDocumentLocations(SearchPattern pattern, SearchScope scope, Map searchOptions, IProgressMonitor monitor) {
        return scope;
    }

    public void createSearchDocuments(SearchDocumentSet documentSet, SearchPattern pattern, SearchScope scope, Map searchOptions, IProgressMonitor monitor) {
        Assert.isNotNull((Object)this.id, (String)"The SearchPartipants id has not been initalized");
        IFile[] files = scope.enclosingFiles();
        int i = 0;
        while (i < files.length) {
            String location = files[i].getLocation().toString();
            SearchDocument document = documentSet.getSearchDocument(location, this.id);
            if (document == null && this.id != null) {
                document = this.createSearchDocument(location);
                documentSet.putSearchDocument(this.id, document);
            }
            this.populateSearchDocument(document, pattern);
            ++i;
        }
    }
}

