/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.completion.provider;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ease.ICompletionContext;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.ease.ui.completion.AbstractCompletionProvider;
import org.eclipse.ease.ui.completion.IImageResolver;
import org.eclipse.ease.ui.completion.provider.LocationResolver;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public abstract class AbstractFileLocationCompletionProvider
extends AbstractCompletionProvider {
    private static final int ORDER_URI_SCHEME = 100;
    private static final int ORDER_PROJECT = 101;
    private static final int ORDER_FOLDER = 102;
    private static final int ORDER_FILE = 103;
    private final ILabelProvider fLabelProvider = new WorkbenchLabelProvider();

    public AbstractFileLocationCompletionProvider() {
        Display.getDefault().syncExec(() -> {
            Image image = this.fLabelProvider.getImage((Object)ResourcesPlugin.getWorkspace().getRoot());
        });
    }

    @Override
    public boolean isActive(ICompletionContext context) {
        return context.getType() == ICompletionContext.Type.STRING_LITERAL;
    }

    @Override
    protected void prepareProposals(ICompletionContext context) {
        LocationResolver resolver = new LocationResolver(context.getFilter(), context.getResource());
        if (AbstractFileLocationCompletionProvider.matches(context.getFilter(), "workspace:/") && this.showCandidate("workspace://")) {
            this.addProposal("workspace://", "workspace://", null, 100, null);
        }
        if (AbstractFileLocationCompletionProvider.matches(context.getFilter(), "project:/") && this.getContext().getResource() instanceof IResource && this.showCandidate("project://")) {
            this.addProposal("project://", "project://", null, 100, null);
        }
        if (AbstractFileLocationCompletionProvider.matches(context.getFilter(), "file://") && this.showCandidate("file:///")) {
            this.addProposal("file:///", "file:///", null, 100, null);
        }
        for (Object object : resolver.getChildren()) {
            if (object instanceof File) {
                String name = ((File)object).getName();
                String suffix = ((File)object).isDirectory() ? "/" : "";
                String parentFolder = resolver.getParentString();
                if (name.isEmpty() && ResourceTools.isWindows()) {
                    name = ((File)object).getPath().substring(0, 2);
                    parentFolder = "file:///";
                }
                String replacement = String.valueOf(parentFolder) + (parentFolder.endsWith("/") ? "" : "/") + name + suffix;
                if (!AbstractFileLocationCompletionProvider.matchesIgnoreCase(resolver.getFilterPart(), name) || !this.showCandidate(object)) continue;
                this.addProposal(name, replacement, (IImageResolver)new ResourceImageResolver(object), 103, null);
                continue;
            }
            if (!(object instanceof IResource) || !AbstractFileLocationCompletionProvider.matchesIgnoreCase(resolver.getFilterPart(), ((IResource)object).getName()) || !this.showCandidate(object)) continue;
            if (object instanceof IProject) {
                this.addProposal(((IProject)object).getName(), String.valueOf(resolver.getParentString()) + ((IProject)object).getName() + '/', (IImageResolver)new ResourceImageResolver(object), 101, null);
                continue;
            }
            if (object instanceof IContainer) {
                this.addProposal(((IContainer)object).getName(), String.valueOf(resolver.getParentString()) + '/' + ((IContainer)object).getName() + '/', (IImageResolver)new ResourceImageResolver(object), 102, null);
                continue;
            }
            this.addProposal(((IResource)object).getName(), String.valueOf(resolver.getParentString()) + '/' + ((IResource)object).getName(), (IImageResolver)new ResourceImageResolver(object), 103, null);
        }
        if (AbstractFileLocationCompletionProvider.matches(resolver.getFilterPart(), "..") && this.showCandidate("..")) {
            Object object = resolver.getParentFolder();
            if (object instanceof IResource && !(object instanceof IWorkspaceRoot)) {
                this.addProposal("..", String.valueOf(resolver.getParentString()) + "../", (IImageResolver)new ResourceImageResolver(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER")), 102, null);
            } else if (object instanceof File && !AbstractFileLocationCompletionProvider.isRootFile((File)object) && !ResourceTools.VIRTUAL_WINDOWS_ROOT.equals(object)) {
                this.addProposal("..", String.valueOf(resolver.getParentString()) + "/../", (IImageResolver)new ResourceImageResolver(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER")), 102, null);
            }
        }
    }

    protected boolean showCandidate(Object candidate) {
        return !(candidate instanceof IProject) || ((IProject)candidate).isOpen();
    }

    private static boolean isRootFile(File file) {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File[] fileArray = File.listRoots();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File rootFile = fileArray[n2];
            if (rootFile.equals(file)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected static boolean hasFileExtension(Object candidate, String extension) {
        if (candidate instanceof File) {
            return ((File)candidate).getName().toLowerCase().endsWith("." + extension.toLowerCase());
        }
        if (candidate instanceof IFile) {
            return ((IFile)candidate).getName().toLowerCase().endsWith("." + extension.toLowerCase());
        }
        return false;
    }

    protected static boolean isFileSystemResource(Object candidate) {
        return "file:///".equals(candidate) || candidate instanceof File;
    }

    protected static boolean isWorkspaceResource(Object candidate) {
        return "workspace:///".equals(candidate) || "project:///".equals(candidate) || candidate instanceof IResource;
    }

    protected static boolean isFile(Object candidate) {
        return candidate instanceof File && ((File)candidate).isFile() || candidate instanceof IFile;
    }

    protected static boolean isFolder(Object candidate) {
        return candidate instanceof File && ((File)candidate).isDirectory() || candidate instanceof IContainer;
    }

    private static class ResourceImageResolver
    implements IImageResolver {
        private final Object fFile;

        public ResourceImageResolver(Object file) {
            this.fFile = file;
        }

        @Override
        public Image getImage() {
            if (this.fFile instanceof IResource) {
                IWorkbenchAdapter adapter = (IWorkbenchAdapter)Platform.getAdapterManager().getAdapter(this.fFile, IWorkbenchAdapter.class);
                return adapter != null ? adapter.getImageDescriptor(this.fFile).createImage() : null;
            }
            if (this.fFile instanceof File) {
                if (AbstractFileLocationCompletionProvider.isRootFile((File)this.fFile)) {
                    return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER").createImage();
                }
                if (((File)this.fFile).isFile()) {
                    return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE").createImage();
                }
                if (((File)this.fFile).isDirectory()) {
                    return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER").createImage();
                }
            } else if (this.fFile instanceof ImageDescriptor) {
                return ((ImageDescriptor)this.fFile).createImage();
            }
            return null;
        }
    }
}

