/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects;

import com.google.common.base.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferReader;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferWriter;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.HostProcessPointer;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.Ros2SerializationUtil;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2CallbackType;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2Object;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2ObjectHandle;

public class Ros2CallbackObject
extends Ros2Object<HostProcessPointer> {
    public static final byte CUSTOM_TYPE_ID = 64;
    public static final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull CustomStateValue.CustomStateValueFactory ROS2_CALLBACK_OBJECT_VALUE_FACTORY = b -> Ros2CallbackObject.read(b);
    private final @NonNull Ros2ObjectHandle fOwnerHandle;
    private final @NonNull String fSymbol;
    private final Ros2CallbackType fType;

    public Ros2CallbackObject(@NonNull HostProcessPointer callback, @NonNull Ros2ObjectHandle ownerHandle, @NonNull String symbol, Ros2CallbackType type) {
        super(callback);
        this.fOwnerHandle = ownerHandle;
        this.fSymbol = symbol;
        this.fType = type;
    }

    public @NonNull HostProcessPointer getCallback() {
        return (HostProcessPointer)((Object)this.getHandle());
    }

    public @NonNull Ros2ObjectHandle getOwnerHandle() {
        return this.fOwnerHandle;
    }

    public @NonNull String getSymbol() {
        return this.fSymbol;
    }

    public Ros2CallbackType getCallbackType() {
        return this.fType;
    }

    @Override
    public String getStringId() {
        return this.getCallback().getStringId();
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fOwnerHandle, this.fSymbol, this.fType, super.hashCode()});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Ros2CallbackObject o = (Ros2CallbackObject)((Object)obj);
        return o.fOwnerHandle.equals((Object)this.fOwnerHandle) && o.fSymbol.equals(this.fSymbol) && o.fType.equals((Object)this.fType);
    }

    @Override
    public String toString() {
        return String.format("Ros2CallbackObject: %s, ownerHandle=[%s], symbol=%s, type=%s", super.toString(), this.fOwnerHandle.toString(), this.fSymbol, this.fType.toString());
    }

    protected @NonNull Byte getCustomTypeId() {
        return (byte)64;
    }

    @Override
    protected void serializeValue(@NonNull ISafeByteBufferWriter buffer) {
        super.serializeValue(buffer);
        this.fOwnerHandle.serializeValue(buffer);
        buffer.putString(this.fSymbol);
        buffer.putInt(this.fType.ordinal());
    }

    @Override
    protected int getSerializedValueSize() {
        int size = 0;
        size += super.getSerializedValueSize();
        size += this.fOwnerHandle.getSerializedValueSize();
        size += Ros2SerializationUtil.getStringSerializedSize(this.fSymbol);
        return size += 4;
    }

    public static @NonNull Ros2CallbackObject read(ISafeByteBufferReader buffer) {
        HostProcessPointer callback = HostProcessPointer.read(buffer);
        Ros2ObjectHandle ownerHandle = Ros2ObjectHandle.read(buffer);
        String symbol = buffer.getString();
        Ros2CallbackType type = Ros2CallbackType.values()[buffer.getInt()];
        return new Ros2CallbackObject(callback, ownerHandle, symbol, type);
    }
}

