/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.core.model;

import com.google.common.base.Objects;
import java.util.Comparator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferReader;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferWriter;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.HostInfo;

public class HostProcess
implements Comparable<HostProcess> {
    private static Comparator<HostProcess> COMPARATOR = Comparator.comparing(HostProcess::getHostId).thenComparing(HostProcess::getPid);
    private static final @NonNull String STRING_ID_SEP = "|";
    private final @NonNull HostInfo fHostId;
    private final @NonNull Long fPid;
    private final int fSerializedValueSize;

    public HostProcess(@NonNull HostInfo hostId, @NonNull Long pid) {
        this.fHostId = hostId;
        this.fPid = pid;
        int size = 0;
        size += this.fHostId.getSerializedValueSize();
        this.fSerializedValueSize = size += 8;
    }

    public @NonNull HostInfo getHostId() {
        return this.fHostId;
    }

    public @NonNull Long getPid() {
        return this.fPid;
    }

    @Override
    public int compareTo(HostProcess o) {
        return COMPARATOR.compare(this, o);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fHostId, this.fPid});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HostProcess o = (HostProcess)obj;
        return o.fHostId.equals(this.fHostId) && o.fPid.equals(this.fPid);
    }

    public @NonNull String getStringId() {
        return String.format("%d%s%s", this.getPid(), STRING_ID_SEP, this.getHostId().getId());
    }

    public @NonNull String toString() {
        return String.format("HostProcess: pid=%d, hostId=[%s]", this.fPid, this.fHostId.toString());
    }

    public void serializeValue(@NonNull ISafeByteBufferWriter buffer) {
        this.fHostId.serializeValue(buffer);
        buffer.putLong(this.fPid.longValue());
    }

    public int getSerializedValueSize() {
        return this.fSerializedValueSize;
    }

    public static final @NonNull HostProcess read(ISafeByteBufferReader buffer) {
        HostInfo hostId = HostInfo.read(buffer);
        Long pid = buffer.getLong();
        return new HostProcess(hostId, pid);
    }
}

