/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui;

import java.net.URI;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.RepositoryNameAndLocationDialog;
import org.eclipse.equinox.internal.provisional.p2.repository.RepositoryEvent;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class LocationNotFoundDialog
implements Runnable {
    private RepositoryTracker repositoryTracker;
    private ProvisioningUI ui;
    private URI location;

    public LocationNotFoundDialog(RepositoryTracker repositoryTracker, ProvisioningUI ui, URI location) {
        this.repositoryTracker = repositoryTracker;
        this.ui = ui;
        this.location = location;
    }

    @Override
    public void run() {
        boolean removeRepository;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench.isClosing()) {
            return;
        }
        Shell shell = ProvUI.getDefaultParentShell();
        int result = MessageDialog.open((int)3, (Shell)shell, (String)ProvUIMessages.ColocatedRepositoryTracker_SiteNotFoundTitle, (String)NLS.bind((String)ProvUIMessages.ColocatedRepositoryTracker_PromptForSiteLocationEdit, (Object)URIUtil.toUnencodedString((URI)this.location)), (int)0, (String[])new String[]{ProvUIMessages.ColocatedRepositoryTracker_SiteNotFound_RemoveButtonLabel, IDialogConstants.NO_LABEL, ProvUIMessages.ColocatedRepositoryTracker_SiteNotFound_EditButtonLabel, ProvUIMessages.ColocatedRepositoryTracker_SiteNotFound_DisableButtonLabel});
        boolean editRepository = result == 2;
        boolean disableRepository = result == 3;
        boolean bl = removeRepository = result == 0;
        if (editRepository) {
            URI correctedLocation;
            RepositoryNameAndLocationDialog dialog = new RepositoryNameAndLocationDialog(shell, this.ui){

                @Override
                protected String getInitialLocationText() {
                    return URIUtil.toUnencodedString((URI)LocationNotFoundDialog.this.location);
                }

                @Override
                protected String getInitialNameText() {
                    String nickname = LocationNotFoundDialog.this.getMetadataRepositoryManager().getRepositoryProperty(LocationNotFoundDialog.this.location, "p2.nickname");
                    return nickname == null ? "" : nickname;
                }
            };
            int ret = dialog.open();
            if (ret == 0 && (correctedLocation = dialog.getLocation()) != null) {
                String name = dialog.getName();
                this.correctLocation(correctedLocation, name);
            }
        } else if (disableRepository) {
            this.disableRepository();
        } else if (removeRepository) {
            this.removeRepository();
        }
    }

    public void removeRepository() {
        this.repositoryTracker.removeRepositories(new URI[]{this.location}, this.ui.getSession());
    }

    public void disableRepository() {
        this.ui.signalRepositoryOperationStart();
        try {
            this.getArtifactRepositoryManager().setEnabled(this.location, false);
        }
        finally {
            RepositoryEvent artifactRepositoryDisabled = new RepositoryEvent(this.location, 1, 8, false);
            this.ui.signalRepositoryOperationComplete(artifactRepositoryDisabled, true);
        }
        this.ui.signalRepositoryOperationStart();
        try {
            this.getMetadataRepositoryManager().setEnabled(this.location, false);
        }
        finally {
            RepositoryEvent metadataRepositoryDisabled = new RepositoryEvent(this.location, 0, 8, false);
            this.ui.signalRepositoryOperationComplete(metadataRepositoryDisabled, true);
        }
    }

    public void correctLocation(URI correctedLocation, String repositoryName) {
        this.ui.signalRepositoryOperationStart();
        try {
            this.repositoryTracker.removeRepositories(new URI[]{this.location}, this.ui.getSession());
            this.repositoryTracker.addRepository(correctedLocation, repositoryName, this.ui.getSession());
        }
        finally {
            this.ui.signalRepositoryOperationComplete(null, true);
        }
    }

    private IMetadataRepositoryManager getMetadataRepositoryManager() {
        return ProvUI.getMetadataRepositoryManager(this.ui.getSession());
    }

    private IArtifactRepositoryManager getArtifactRepositoryManager() {
        return ProvUI.getArtifactRepositoryManager(this.ui.getSession());
    }
}

