/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.debugging.model;

import java.lang.reflect.Array;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.ease.debugging.model.EaseDebugVariable;

public class EaseJavaArrayElementVariable
extends EaseDebugVariable {
    private final Object fBackingJavaObject;
    private final int fIndex;

    private static Object convert(String expression, Class<? extends Object> clazz) {
        if (Integer.TYPE.equals(clazz) || Integer.class.equals(clazz)) {
            return Integer.parseInt(expression);
        }
        if ((Character.TYPE.equals(clazz) || Character.class.equals(clazz)) && expression.length() == 1) {
            return Character.valueOf(expression.charAt(0));
        }
        throw new IllegalArgumentException("Could not convert <" + expression + "> to " + clazz.getName());
    }

    private static boolean isSimpleType(Class<?> type) {
        if (Integer.TYPE.equals(type) || Integer.class.equals(type)) {
            return true;
        }
        if (Short.TYPE.equals(type) || Short.class.equals(type)) {
            return true;
        }
        if (Byte.TYPE.equals(type) || Byte.class.equals(type)) {
            return true;
        }
        if (Character.TYPE.equals(type) || Character.class.equals(type)) {
            return true;
        }
        if (Long.TYPE.equals(type) || Long.class.equals(type)) {
            return true;
        }
        if (Float.TYPE.equals(type) || Float.class.equals(type)) {
            return true;
        }
        if (Double.TYPE.equals(type) || Double.class.equals(type)) {
            return true;
        }
        if (Boolean.TYPE.equals(type) || Boolean.class.equals(type)) {
            return true;
        }
        return String.class.equals(type);
    }

    public EaseJavaArrayElementVariable(int index, Object backingJavaObject, IDebugElement parent) {
        super("[" + index + "]", Array.get(backingJavaObject, index), parent, null);
        this.fIndex = index;
        this.fBackingJavaObject = backingJavaObject;
        this.getValue().setParent(parent);
    }

    @Override
    public String getReferenceTypeName() {
        return this.fBackingJavaObject.getClass().getComponentType().getSimpleName();
    }

    @Override
    public EaseDebugVariable.Type getType() {
        return EaseDebugVariable.Type.JAVA_OBJECT;
    }

    @Override
    public void setValue(String expression) {
        Array.set(this.fBackingJavaObject, this.fIndex, EaseJavaArrayElementVariable.convert(expression, this.fBackingJavaObject.getClass().getComponentType()));
    }

    @Override
    public boolean supportsValueModification() {
        return EaseJavaArrayElementVariable.isSimpleType(this.fBackingJavaObject.getClass().getComponentType());
    }
}

