/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model.extension.impl;

import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.settings.model.extension.CFileData;
import org.eclipse.cdt.core.settings.model.extension.CFolderData;
import org.eclipse.cdt.core.settings.model.extension.CLanguageData;
import org.eclipse.cdt.core.settings.model.extension.impl.CDataFactory;
import org.eclipse.core.runtime.IPath;

public class CDefaultFileData
extends CFileData {
    protected IPath fPath;
    protected String fName;
    protected String fId;
    protected CLanguageData fLanguageData;
    protected CConfigurationData fCfg;
    private CDataFactory fFactory;
    protected boolean fIsModified;

    public CDefaultFileData(CConfigurationData cfg, CDataFactory factory) {
        this.fCfg = cfg;
        if (factory == null) {
            factory = new CDataFactory();
        }
        this.fFactory = factory;
    }

    public CDefaultFileData(String id, IPath path, CConfigurationData cfg, CDataFactory factory) {
        this(cfg, factory);
        this.fId = id;
        this.fName = path.toString();
        this.fPath = path;
    }

    public CDefaultFileData(String id, IPath path, CFileData base, CConfigurationData cfg, CDataFactory factory, boolean clone) {
        this(id, path, cfg, factory);
        this.copyDataFrom(base, clone);
    }

    public CDefaultFileData(String id, IPath path, CFolderData base, CLanguageData baseLangData, CConfigurationData cfg, CDataFactory factory) {
        this(id, path, cfg, factory);
        this.copyDataFrom(base, baseLangData);
    }

    protected void copyDataFrom(CFileData base, boolean clone) {
        CLanguageData baseLanguageData = base.getLanguageData();
        if (baseLanguageData != null) {
            this.fLanguageData = this.copyLanguageData(baseLanguageData, clone);
        }
    }

    protected void copyDataFrom(CFolderData base, CLanguageData baseLanguageData) {
        if (baseLanguageData != null) {
            this.fLanguageData = this.copyLanguageData(baseLanguageData, false);
        }
    }

    protected CLanguageData copyLanguageData(CLanguageData data, boolean clone) {
        return this.fFactory.createLanguageData(this.fCfg, this, data, null, clone);
    }

    @Override
    public IPath getPath() {
        return this.fPath;
    }

    @Override
    public void setPath(IPath path) {
        this.fPath = path;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        this.fName = name;
    }

    @Override
    public String getId() {
        return this.fId;
    }

    @Override
    public boolean isValid() {
        return this.getId() != null;
    }

    @Override
    public CLanguageData getLanguageData() {
        return this.fLanguageData;
    }

    public boolean isModified() {
        if (this.fIsModified) {
            return true;
        }
        return this.fFactory.isModified(this.fLanguageData);
    }

    public void setModified(boolean modified) {
        this.fIsModified = modified;
        if (!modified) {
            this.fFactory.setModified(this.fLanguageData, false);
        }
    }

    @Override
    public boolean hasCustomSettings() {
        return false;
    }
}

