/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.core.helpers;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import org.eclipse.equinox.internal.p2.core.helpers.TarEntry;
import org.eclipse.equinox.internal.p2.core.helpers.TarException;
import org.eclipse.equinox.internal.p2.core.helpers.TarInputStream;

public class TarFile
implements Closeable {
    private File file;
    private TarInputStream entryEnumerationStream;
    private TarInputStream entryStream;
    private InputStream internalEntryStream;

    public TarFile(File file) throws TarException, IOException {
        this.file = file;
        InputStream in = new FileInputStream(file);
        try {
            in = new GZIPInputStream(in);
        }
        catch (IOException e) {
            in.close();
            in = new FileInputStream(file);
        }
        try {
            this.entryEnumerationStream = new TarInputStream(in);
        }
        catch (TarException ex) {
            in.close();
            throw ex;
        }
    }

    @Override
    public void close() throws IOException {
        this.entryEnumerationStream.close();
        if (this.internalEntryStream != null) {
            this.internalEntryStream.close();
        }
    }

    public Iterable<TarEntry> entries() throws TarException, IOException {
        TarEntry first = this.entryEnumerationStream.getNextEntry();
        return Stream.iterate(first, Objects::nonNull, e -> {
            try {
                return this.entryEnumerationStream.getNextEntry();
            }
            catch (IOException | TarException e1) {
                return null;
            }
        })::iterator;
    }

    public InputStream getInputStream(TarEntry entry) throws TarException, IOException {
        if (this.entryStream == null || !this.entryStream.skipToEntry(entry)) {
            if (this.internalEntryStream != null) {
                this.internalEntryStream.close();
            }
            this.internalEntryStream = new FileInputStream(this.file);
            try {
                this.internalEntryStream = new GZIPInputStream(this.internalEntryStream);
            }
            catch (IOException e) {
                this.internalEntryStream.close();
                this.internalEntryStream = new FileInputStream(this.file);
            }
            this.entryStream = new TarInputStream(this.internalEntryStream, entry){

                @Override
                public void close() {
                }
            };
        }
        return this.entryStream;
    }

    public String getName() {
        return this.file.getPath();
    }
}

