/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.TarFile;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageFilesElement;

public abstract class AbstractTracePackageOperation {
    private IStatus fStatus;
    private TracePackageElement[] fResultElements;
    private final String fFileName;

    public AbstractTracePackageOperation(String fileName) {
        this.fFileName = fileName;
    }

    public abstract void run(IProgressMonitor var1);

    public IStatus getStatus() {
        return this.fStatus;
    }

    public TracePackageElement[] getResultElements() {
        return this.fResultElements;
    }

    public void setResultElements(TracePackageElement[] elements) {
        this.fResultElements = elements;
    }

    protected void setStatus(IStatus status) {
        this.fStatus = status;
    }

    protected String getFileName() {
        return this.fFileName;
    }

    public ArchiveFile getSpecifiedArchiveFile() {
        if (this.fFileName.length() == 0) {
            return null;
        }
        File file = new File(this.fFileName);
        if (file.isDirectory()) {
            return null;
        }
        try {
            return new ZipArchiveFile(new ZipFile(file));
        }
        catch (IOException iOException) {
            try {
                return new TarArchiveFile(new TarFile(file));
            }
            catch (IOException iOException2) {
                return null;
            }
        }
    }

    protected int getNbCheckedElements(TracePackageElement[] elements) {
        int totalWork = 0;
        TracePackageElement[] tracePackageElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            TracePackageElement tracePackageElement = tracePackageElementArray[n2];
            TracePackageElement[] children = tracePackageElement.getChildren();
            if (children != null && children.length > 0) {
                totalWork += this.getNbCheckedElements(children);
            } else if (tracePackageElement.isChecked()) {
                ++totalWork;
            }
            ++n2;
        }
        return totalWork;
    }

    public static boolean isFilesChecked(TracePackageElement tracePackageElement) {
        TracePackageElement[] tracePackageElementArray = tracePackageElement.getChildren();
        int n = tracePackageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            TracePackageElement element = tracePackageElementArray[n2];
            if (element instanceof TracePackageFilesElement) {
                return element.isChecked();
            }
            ++n2;
        }
        return false;
    }

    protected static interface ArchiveEntry {
        public String getName();
    }

    protected static interface ArchiveFile {
        public Enumeration<@NonNull ? extends ArchiveEntry> entries();

        public void close() throws IOException;

        public InputStream getInputStream(ArchiveEntry var1) throws IOException;
    }

    protected class TarArchiveEntryAdapter
    implements ArchiveEntry {
        private TarArchiveEntry fTarEntry;

        public TarArchiveEntryAdapter(TarArchiveEntry tarEntry) {
            this.fTarEntry = tarEntry;
        }

        @Override
        public String getName() {
            return this.fTarEntry.getName();
        }

        public TarArchiveEntry getTarEntry() {
            return this.fTarEntry;
        }

        public String toString() {
            return this.getName();
        }
    }

    protected class TarArchiveFile
    implements ArchiveFile {
        private TarFile fTarFile;

        public TarArchiveFile(TarFile tarFile) {
            this.fTarFile = tarFile;
        }

        @Override
        public Enumeration<@NonNull ? extends ArchiveEntry> entries() {
            Vector<@NonNull AbstractTracePackageOperation.TarArchiveEntryAdapter> v = new Vector<TarArchiveEntryAdapter>();
            Enumeration<TarArchiveEntry> e = this.fTarFile.entries();
            while (e.hasMoreElements()) {
                v.add(new TarArchiveEntryAdapter(e.nextElement()));
            }
            return v.elements();
        }

        @Override
        public void close() throws IOException {
            this.fTarFile.close();
        }

        @Override
        public InputStream getInputStream(ArchiveEntry entry) throws IOException {
            return this.fTarFile.getInputStream(((TarArchiveEntryAdapter)entry).getTarEntry());
        }
    }

    protected class ZipAchiveEntryAdapter
    implements ArchiveEntry {
        private ZipArchiveEntry fZipEntry;

        public ZipAchiveEntryAdapter(ZipArchiveEntry zipEntry) {
            this.fZipEntry = zipEntry;
        }

        @Override
        public String getName() {
            return this.fZipEntry.getName();
        }

        public ZipArchiveEntry getZipEntry() {
            return this.fZipEntry;
        }

        public String toString() {
            return this.getName();
        }
    }

    protected class ZipArchiveFile
    implements ArchiveFile {
        private ZipFile fZipFile;

        public ZipArchiveFile(ZipFile zipFile) {
            this.fZipFile = zipFile;
        }

        @Override
        public Enumeration<@NonNull ? extends ArchiveEntry> entries() {
            Vector<@NonNull AbstractTracePackageOperation.ZipAchiveEntryAdapter> v = new Vector<ZipAchiveEntryAdapter>();
            Enumeration e = this.fZipFile.getEntries();
            while (e.hasMoreElements()) {
                v.add(new ZipAchiveEntryAdapter((ZipArchiveEntry)e.nextElement()));
            }
            return v.elements();
        }

        @Override
        public void close() throws IOException {
            this.fZipFile.close();
        }

        @Override
        public InputStream getInputStream(ArchiveEntry entry) throws IOException {
            return this.fZipFile.getInputStream(((ZipAchiveEntryAdapter)entry).getZipEntry());
        }
    }
}

