/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.analysis.mtl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.trace4cps.analysis.mtl.ExplanationTable;
import org.eclipse.trace4cps.analysis.mtl.InformativePrefix;
import org.eclipse.trace4cps.analysis.mtl.MtlException;
import org.eclipse.trace4cps.analysis.mtl.MtlFormula;
import org.eclipse.trace4cps.analysis.mtl.MtlResult;

public final class MtlFuture
implements Future<List<MtlResult>> {
    private final Object lock = new Object();
    private final int total;
    private int numDone;
    private int numSatisfied = 0;
    private int numNeutral = 0;
    private int numNotSatisfied = 0;
    private boolean canceled = false;
    private long startTime;
    private long endTime;
    private final List<MtlResult> result = new ArrayList<MtlResult>();
    private int numErrors = 0;
    private final ExecutorService exec;

    MtlFuture(int size, ExecutorService exec) {
        this.total = size;
        this.exec = exec;
        this.startTime = System.nanoTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotal() {
        Object object = this.lock;
        synchronized (object) {
            return this.total;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumDone() {
        Object object = this.lock;
        synchronized (object) {
            return this.numDone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumGood() {
        Object object = this.lock;
        synchronized (object) {
            return this.numSatisfied;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumNeutral() {
        Object object = this.lock;
        synchronized (object) {
            return this.numNeutral;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumBad() {
        Object object = this.lock;
        synchronized (object) {
            return this.numNotSatisfied;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getComputationTimeInMs() {
        Object object = this.lock;
        synchronized (object) {
            return (this.endTime - this.startTime) / 1000000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Object object = this.lock;
        synchronized (object) {
            block4: {
                if (this.canceled) break block4;
                this.canceled = true;
                this.exec.shutdownNow();
                return true;
            }
            return this.canceled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        Object object = this.lock;
        synchronized (object) {
            return this.canceled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        Object object = this.lock;
        synchronized (object) {
            return this.total == this.numDone + this.numErrors;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MtlResult> get() throws InterruptedException, ExecutionException {
        Object object = this.lock;
        synchronized (object) {
            while (!this.isDone()) {
                this.lock.wait();
            }
            return this.result;
        }
    }

    @Override
    public List<MtlResult> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToResult(MtlFormula phi, InformativePrefix sat, ExplanationTable expl) throws MtlException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isDone()) {
                throw new MtlException("I am already done!");
            }
            this.result.add(new MtlResult(phi, sat, expl));
            ++this.numDone;
            if (sat == InformativePrefix.GOOD) {
                ++this.numSatisfied;
            } else if (sat == InformativePrefix.BAD) {
                ++this.numNotSatisfied;
            } else if (sat == InformativePrefix.NON_INFORMATIVE) {
                ++this.numNeutral;
            }
            if (this.isDone()) {
                this.endTime = System.nanoTime();
                this.exec.shutdownNow();
            }
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addError(Throwable th) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isDone()) {
                ++this.numErrors;
            }
            if (this.isDone()) {
                this.endTime = System.nanoTime();
                this.exec.shutdownNow();
            }
            this.lock.notifyAll();
        }
    }
}

