/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui;

import javafx.geometry.Bounds;
import javafx.scene.Group;
import org.eclipse.gef.fx.nodes.GeometryNode;
import org.eclipse.gef.geometry.planar.IGeometry;
import org.eclipse.gef.graph.Node;
import org.eclipse.gef.zest.fx.parts.NodePart;

public class DotNodePart
extends NodePart {
    public static String DOT_PROPERTY_INNER_SHAPE__N = "dotInnerShape__n";
    public static String DOT_PROPERTY_INNER_SHAPE_DISTANCE__N = "dotInnerShapeDistance__n";
    protected GeometryNode<IGeometry> innerShape;

    protected Group doCreateVisual() {
        Group visual = super.doCreateVisual();
        this.innerShape = new GeometryNode();
        visual.getChildren().add(1, this.innerShape);
        return visual;
    }

    protected void doRefreshVisual(Group visual) {
        super.doRefreshVisual(visual);
        Node node = this.getContent();
        if (node.attributesProperty().containsKey((Object)DOT_PROPERTY_INNER_SHAPE__N)) {
            this.innerShape = (GeometryNode)node.attributesProperty().get((Object)DOT_PROPERTY_INNER_SHAPE__N);
            double innerDistance = 0.0;
            if (node.attributesProperty().containsKey((Object)DOT_PROPERTY_INNER_SHAPE__N)) {
                innerDistance = (Double)node.attributesProperty().get((Object)DOT_PROPERTY_INNER_SHAPE_DISTANCE__N);
            }
            Bounds b = this.getShape().getBoundsInLocal();
            this.innerShape.resizeRelocate(b.getMinX() + innerDistance, b.getMinY() + innerDistance, b.getWidth() - 2.0 * innerDistance, b.getHeight() - 2.0 * innerDistance);
            if (!((Group)this.getVisual()).getChildren().contains(this.innerShape)) {
                visual.getChildren().add(1, this.innerShape);
            }
        }
    }
}

