/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Control;

public class SelectionManager {
    private EditPart focusPart;
    private Runnable notifier;
    private List selection;
    private EditPartViewer viewer;

    protected SelectionManager() {
    }

    public static SelectionManager createDefault() {
        return new SelectionManager();
    }

    public void appendSelection(EditPart editpart) {
        if (editpart != this.getFocus()) {
            this.viewer.setFocus(null);
        }
        if (!this.selection.isEmpty()) {
            EditPart primary = (EditPart)this.selection.get(this.selection.size() - 1);
            primary.setSelected(1);
        }
        this.selection.remove(editpart);
        this.selection.add(editpart);
        editpart.setSelected(2);
        this.fireSelectionChanged();
    }

    public void deselect(EditPart editpart) {
        editpart.setSelected(0);
        this.selection.remove(editpart);
        if (!this.selection.isEmpty()) {
            EditPart primary = (EditPart)this.selection.get(this.selection.size() - 1);
            primary.setSelected(2);
        }
        this.fireSelectionChanged();
    }

    public void deselectAll() {
        this.setFocus(null);
        int i = 0;
        while (i < this.selection.size()) {
            EditPart part = (EditPart)this.selection.get(i);
            part.setSelected(0);
            ++i;
        }
        this.selection.clear();
        this.fireSelectionChanged();
    }

    protected final void fireSelectionChanged() {
        this.notifier.run();
    }

    protected EditPart getFocus() {
        return this.focusPart;
    }

    public ISelection getSelection() {
        if (this.selection.isEmpty() && this.viewer.getContents() != null) {
            return new StructuredSelection((Object)this.viewer.getContents());
        }
        return new StructuredSelection(this.selection);
    }

    protected EditPartViewer getViewer() {
        return this.viewer;
    }

    public void internalHookControl(Control control) {
    }

    public void internalUninstall() {
    }

    protected void hookViewer(EditPartViewer viewer) {
    }

    public void internalInitialize(EditPartViewer viewer, List selection, Runnable notifier) {
        this.viewer = viewer;
        this.selection = selection;
        this.notifier = notifier;
        this.hookViewer(viewer);
    }

    public void setFocus(EditPart part) {
        if (this.focusPart == part) {
            return;
        }
        if (this.focusPart != null) {
            this.focusPart.setFocus(false);
        }
        this.focusPart = part;
        if (this.focusPart != null) {
            this.focusPart.setFocus(true);
        }
    }

    public void setSelection(ISelection newSelection) {
        EditPart part;
        if (!(newSelection instanceof IStructuredSelection)) {
            return;
        }
        List orderedSelection = ((IStructuredSelection)newSelection).toList();
        HashSet hashset = new HashSet(orderedSelection);
        this.setFocus(null);
        int i = 0;
        while (i < this.selection.size()) {
            part = (EditPart)this.selection.get(i);
            if (!hashset.contains(part)) {
                part.setSelected(0);
            }
            ++i;
        }
        this.selection.clear();
        if (!orderedSelection.isEmpty()) {
            Iterator itr = orderedSelection.iterator();
            while (true) {
                part = (EditPart)itr.next();
                this.selection.add(part);
                if (!itr.hasNext()) {
                    part.setSelected(2);
                    break;
                }
                part.setSelected(1);
            }
        }
        this.fireSelectionChanged();
    }
}

